// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerRegistry.Models
{
    /// <summary>
    /// The authentication mode which determines the source registry login scope. The credentials for the source registry
    /// will be generated using the given scope. These credentials will be used to login to
    /// the source registry during the run.
    /// </summary>
    public readonly partial struct SourceRegistryLoginMode : IEquatable<SourceRegistryLoginMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SourceRegistryLoginMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SourceRegistryLoginMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string DefaultValue = "Default";

        /// <summary> None. </summary>
        public static SourceRegistryLoginMode None { get; } = new SourceRegistryLoginMode(NoneValue);
        /// <summary> Default. </summary>
        public static SourceRegistryLoginMode Default { get; } = new SourceRegistryLoginMode(DefaultValue);
        /// <summary> Determines if two <see cref="SourceRegistryLoginMode"/> values are the same. </summary>
        public static bool operator ==(SourceRegistryLoginMode left, SourceRegistryLoginMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SourceRegistryLoginMode"/> values are not the same. </summary>
        public static bool operator !=(SourceRegistryLoginMode left, SourceRegistryLoginMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SourceRegistryLoginMode"/>. </summary>
        public static implicit operator SourceRegistryLoginMode(string value) => new SourceRegistryLoginMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SourceRegistryLoginMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SourceRegistryLoginMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
