// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerRegistry.Models
{
    /// <summary> The type of source control service. </summary>
    public readonly partial struct SourceControlType : IEquatable<SourceControlType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SourceControlType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SourceControlType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string GithubValue = "Github";
        private const string VisualStudioTeamServiceValue = "VisualStudioTeamService";

        /// <summary> Github. </summary>
        public static SourceControlType Github { get; } = new SourceControlType(GithubValue);
        /// <summary> VisualStudioTeamService. </summary>
        public static SourceControlType VisualStudioTeamService { get; } = new SourceControlType(VisualStudioTeamServiceValue);
        /// <summary> Determines if two <see cref="SourceControlType"/> values are the same. </summary>
        public static bool operator ==(SourceControlType left, SourceControlType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SourceControlType"/> values are not the same. </summary>
        public static bool operator !=(SourceControlType left, SourceControlType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SourceControlType"/>. </summary>
        public static implicit operator SourceControlType(string value) => new SourceControlType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SourceControlType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SourceControlType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
