// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerRegistry.Models
{
    /// <summary> The status of the webhook at the time the operation was called. </summary>
    public readonly partial struct ContainerRegistryWebhookStatus : IEquatable<ContainerRegistryWebhookStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerRegistryWebhookStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerRegistryWebhookStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "enabled";
        private const string DisabledValue = "disabled";

        /// <summary> enabled. </summary>
        public static ContainerRegistryWebhookStatus Enabled { get; } = new ContainerRegistryWebhookStatus(EnabledValue);
        /// <summary> disabled. </summary>
        public static ContainerRegistryWebhookStatus Disabled { get; } = new ContainerRegistryWebhookStatus(DisabledValue);
        /// <summary> Determines if two <see cref="ContainerRegistryWebhookStatus"/> values are the same. </summary>
        public static bool operator ==(ContainerRegistryWebhookStatus left, ContainerRegistryWebhookStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerRegistryWebhookStatus"/> values are not the same. </summary>
        public static bool operator !=(ContainerRegistryWebhookStatus left, ContainerRegistryWebhookStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerRegistryWebhookStatus"/>. </summary>
        public static implicit operator ContainerRegistryWebhookStatus(string value) => new ContainerRegistryWebhookStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerRegistryWebhookStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerRegistryWebhookStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
