// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ContainerRegistry.Models
{
    /// <summary> The event for a webhook. </summary>
    public partial class ContainerRegistryWebhookEvent : ContainerRegistryWebhookEventInfo
    {
        /// <summary> Initializes a new instance of <see cref="ContainerRegistryWebhookEvent"/>. </summary>
        internal ContainerRegistryWebhookEvent()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ContainerRegistryWebhookEvent"/>. </summary>
        /// <param name="id"> The event ID. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="eventRequestMessage"> The event request message sent to the service URI. </param>
        /// <param name="eventResponseMessage"> The event response message received from the service URI. </param>
        internal ContainerRegistryWebhookEvent(Guid? id, IDictionary<string, BinaryData> serializedAdditionalRawData, ContainerRegistryWebhookEventRequestMessage eventRequestMessage, ContainerRegistryWebhookEventResponseMessage eventResponseMessage) : base(id, serializedAdditionalRawData)
        {
            EventRequestMessage = eventRequestMessage;
            EventResponseMessage = eventResponseMessage;
        }

        /// <summary> The event request message sent to the service URI. </summary>
        [WirePath("eventRequestMessage")]
        public ContainerRegistryWebhookEventRequestMessage EventRequestMessage { get; }
        /// <summary> The event response message received from the service URI. </summary>
        [WirePath("eventResponseMessage")]
        public ContainerRegistryWebhookEventResponseMessage EventResponseMessage { get; }
    }
}
