// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerRegistry.Models
{
    /// <summary> The unit of measurement. </summary>
    public readonly partial struct ContainerRegistryUsageUnit : IEquatable<ContainerRegistryUsageUnit>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerRegistryUsageUnit"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerRegistryUsageUnit(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CountValue = "Count";
        private const string BytesValue = "Bytes";

        /// <summary> Count. </summary>
        public static ContainerRegistryUsageUnit Count { get; } = new ContainerRegistryUsageUnit(CountValue);
        /// <summary> Bytes. </summary>
        public static ContainerRegistryUsageUnit Bytes { get; } = new ContainerRegistryUsageUnit(BytesValue);
        /// <summary> Determines if two <see cref="ContainerRegistryUsageUnit"/> values are the same. </summary>
        public static bool operator ==(ContainerRegistryUsageUnit left, ContainerRegistryUsageUnit right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerRegistryUsageUnit"/> values are not the same. </summary>
        public static bool operator !=(ContainerRegistryUsageUnit left, ContainerRegistryUsageUnit right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerRegistryUsageUnit"/>. </summary>
        public static implicit operator ContainerRegistryUsageUnit(string value) => new ContainerRegistryUsageUnit(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerRegistryUsageUnit other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerRegistryUsageUnit other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
