// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerRegistry.Models
{
    /// <summary> The type of trust policy. </summary>
    public readonly partial struct ContainerRegistryTrustPolicyType : IEquatable<ContainerRegistryTrustPolicyType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerRegistryTrustPolicyType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerRegistryTrustPolicyType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotaryValue = "Notary";

        /// <summary> Notary. </summary>
        public static ContainerRegistryTrustPolicyType Notary { get; } = new ContainerRegistryTrustPolicyType(NotaryValue);
        /// <summary> Determines if two <see cref="ContainerRegistryTrustPolicyType"/> values are the same. </summary>
        public static bool operator ==(ContainerRegistryTrustPolicyType left, ContainerRegistryTrustPolicyType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerRegistryTrustPolicyType"/> values are not the same. </summary>
        public static bool operator !=(ContainerRegistryTrustPolicyType left, ContainerRegistryTrustPolicyType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerRegistryTrustPolicyType"/>. </summary>
        public static implicit operator ContainerRegistryTrustPolicyType(string value) => new ContainerRegistryTrustPolicyType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerRegistryTrustPolicyType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerRegistryTrustPolicyType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
