// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerRegistry.Models
{
    /// <summary> The status of the token example enabled or disabled. </summary>
    public readonly partial struct ContainerRegistryTokenStatus : IEquatable<ContainerRegistryTokenStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerRegistryTokenStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerRegistryTokenStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "enabled";
        private const string DisabledValue = "disabled";

        /// <summary> enabled. </summary>
        public static ContainerRegistryTokenStatus Enabled { get; } = new ContainerRegistryTokenStatus(EnabledValue);
        /// <summary> disabled. </summary>
        public static ContainerRegistryTokenStatus Disabled { get; } = new ContainerRegistryTokenStatus(DisabledValue);
        /// <summary> Determines if two <see cref="ContainerRegistryTokenStatus"/> values are the same. </summary>
        public static bool operator ==(ContainerRegistryTokenStatus left, ContainerRegistryTokenStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerRegistryTokenStatus"/> values are not the same. </summary>
        public static bool operator !=(ContainerRegistryTokenStatus left, ContainerRegistryTokenStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerRegistryTokenStatus"/>. </summary>
        public static implicit operator ContainerRegistryTokenStatus(string value) => new ContainerRegistryTokenStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerRegistryTokenStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerRegistryTokenStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
