// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerRegistry.Models
{
    /// <summary> The ContainerRegistryTokenCertificateName. </summary>
    public readonly partial struct ContainerRegistryTokenCertificateName : IEquatable<ContainerRegistryTokenCertificateName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerRegistryTokenCertificateName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerRegistryTokenCertificateName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string Certificate1Value = "certificate1";
        private const string Certificate2Value = "certificate2";

        /// <summary> certificate1. </summary>
        public static ContainerRegistryTokenCertificateName Certificate1 { get; } = new ContainerRegistryTokenCertificateName(Certificate1Value);
        /// <summary> certificate2. </summary>
        public static ContainerRegistryTokenCertificateName Certificate2 { get; } = new ContainerRegistryTokenCertificateName(Certificate2Value);
        /// <summary> Determines if two <see cref="ContainerRegistryTokenCertificateName"/> values are the same. </summary>
        public static bool operator ==(ContainerRegistryTokenCertificateName left, ContainerRegistryTokenCertificateName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerRegistryTokenCertificateName"/> values are not the same. </summary>
        public static bool operator !=(ContainerRegistryTokenCertificateName left, ContainerRegistryTokenCertificateName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerRegistryTokenCertificateName"/>. </summary>
        public static implicit operator ContainerRegistryTokenCertificateName(string value) => new ContainerRegistryTokenCertificateName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerRegistryTokenCertificateName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerRegistryTokenCertificateName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
