// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ContainerRegistry.Models
{
    /// <summary> The source trigger that caused a run. </summary>
    public partial class ContainerRegistrySourceTriggerDescriptor
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerRegistrySourceTriggerDescriptor"/>. </summary>
        public ContainerRegistrySourceTriggerDescriptor()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ContainerRegistrySourceTriggerDescriptor"/>. </summary>
        /// <param name="id"> The unique ID of the trigger. </param>
        /// <param name="eventType"> The event type of the trigger. </param>
        /// <param name="commitId"> The unique ID that identifies a commit. </param>
        /// <param name="pullRequestId"> The unique ID that identifies pull request. </param>
        /// <param name="repositoryUri"> The repository URL. </param>
        /// <param name="branchName"> The branch name in the repository. </param>
        /// <param name="providerType"> The source control provider type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerRegistrySourceTriggerDescriptor(Guid? id, string eventType, string commitId, string pullRequestId, Uri repositoryUri, string branchName, string providerType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            EventType = eventType;
            CommitId = commitId;
            PullRequestId = pullRequestId;
            RepositoryUri = repositoryUri;
            BranchName = branchName;
            ProviderType = providerType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The unique ID of the trigger. </summary>
        [WirePath("id")]
        public Guid? Id { get; set; }
        /// <summary> The event type of the trigger. </summary>
        [WirePath("eventType")]
        public string EventType { get; set; }
        /// <summary> The unique ID that identifies a commit. </summary>
        [WirePath("commitId")]
        public string CommitId { get; set; }
        /// <summary> The unique ID that identifies pull request. </summary>
        [WirePath("pullRequestId")]
        public string PullRequestId { get; set; }
        /// <summary> The repository URL. </summary>
        [WirePath("repositoryUrl")]
        public Uri RepositoryUri { get; set; }
        /// <summary> The branch name in the repository. </summary>
        [WirePath("branchName")]
        public string BranchName { get; set; }
        /// <summary> The source control provider type. </summary>
        [WirePath("providerType")]
        public string ProviderType { get; set; }
    }
}
