// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerRegistry.Models
{
    /// <summary> The SKU tier based on the SKU name. </summary>
    public readonly partial struct ContainerRegistrySkuTier : IEquatable<ContainerRegistrySkuTier>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerRegistrySkuTier"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerRegistrySkuTier(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ClassicValue = "Classic";
        private const string BasicValue = "Basic";
        private const string StandardValue = "Standard";
        private const string PremiumValue = "Premium";

        /// <summary> Classic. </summary>
        public static ContainerRegistrySkuTier Classic { get; } = new ContainerRegistrySkuTier(ClassicValue);
        /// <summary> Basic. </summary>
        public static ContainerRegistrySkuTier Basic { get; } = new ContainerRegistrySkuTier(BasicValue);
        /// <summary> Standard. </summary>
        public static ContainerRegistrySkuTier Standard { get; } = new ContainerRegistrySkuTier(StandardValue);
        /// <summary> Premium. </summary>
        public static ContainerRegistrySkuTier Premium { get; } = new ContainerRegistrySkuTier(PremiumValue);
        /// <summary> Determines if two <see cref="ContainerRegistrySkuTier"/> values are the same. </summary>
        public static bool operator ==(ContainerRegistrySkuTier left, ContainerRegistrySkuTier right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerRegistrySkuTier"/> values are not the same. </summary>
        public static bool operator !=(ContainerRegistrySkuTier left, ContainerRegistrySkuTier right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerRegistrySkuTier"/>. </summary>
        public static implicit operator ContainerRegistrySkuTier(string value) => new ContainerRegistrySkuTier(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerRegistrySkuTier other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerRegistrySkuTier other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
