// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ContainerRegistry.Models
{
    /// <summary> Describes the properties of a secret object value. </summary>
    public partial class ContainerRegistrySecretObject
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerRegistrySecretObject"/>. </summary>
        public ContainerRegistrySecretObject()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ContainerRegistrySecretObject"/>. </summary>
        /// <param name="value">
        /// The value of the secret. The format of this value will be determined
        /// based on the type of the secret object. If the type is Opaque, the value will be
        /// used as is without any modification.
        /// </param>
        /// <param name="objectType">
        /// The type of the secret object which determines how the value of the secret object has to be
        /// interpreted.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerRegistrySecretObject(string value, ContainerRegistrySecretObjectType? objectType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Value = value;
            ObjectType = objectType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// The value of the secret. The format of this value will be determined
        /// based on the type of the secret object. If the type is Opaque, the value will be
        /// used as is without any modification.
        /// </summary>
        [WirePath("value")]
        public string Value { get; set; }
        /// <summary>
        /// The type of the secret object which determines how the value of the secret object has to be
        /// interpreted.
        /// </summary>
        [WirePath("type")]
        public ContainerRegistrySecretObjectType? ObjectType { get; set; }
    }
}
