// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerRegistry.Models
{
    /// <summary> The type of run. </summary>
    public readonly partial struct ContainerRegistryRunType : IEquatable<ContainerRegistryRunType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerRegistryRunType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerRegistryRunType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string QuickBuildValue = "QuickBuild";
        private const string QuickRunValue = "QuickRun";
        private const string AutoBuildValue = "AutoBuild";
        private const string AutoRunValue = "AutoRun";

        /// <summary> QuickBuild. </summary>
        public static ContainerRegistryRunType QuickBuild { get; } = new ContainerRegistryRunType(QuickBuildValue);
        /// <summary> QuickRun. </summary>
        public static ContainerRegistryRunType QuickRun { get; } = new ContainerRegistryRunType(QuickRunValue);
        /// <summary> AutoBuild. </summary>
        public static ContainerRegistryRunType AutoBuild { get; } = new ContainerRegistryRunType(AutoBuildValue);
        /// <summary> AutoRun. </summary>
        public static ContainerRegistryRunType AutoRun { get; } = new ContainerRegistryRunType(AutoRunValue);
        /// <summary> Determines if two <see cref="ContainerRegistryRunType"/> values are the same. </summary>
        public static bool operator ==(ContainerRegistryRunType left, ContainerRegistryRunType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerRegistryRunType"/> values are not the same. </summary>
        public static bool operator !=(ContainerRegistryRunType left, ContainerRegistryRunType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerRegistryRunType"/>. </summary>
        public static implicit operator ContainerRegistryRunType(string value) => new ContainerRegistryRunType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerRegistryRunType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerRegistryRunType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
