// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ContainerRegistry.Models
{
    /// <summary> The retention policy for a container registry. </summary>
    public partial class ContainerRegistryRetentionPolicy
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerRegistryRetentionPolicy"/>. </summary>
        public ContainerRegistryRetentionPolicy()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ContainerRegistryRetentionPolicy"/>. </summary>
        /// <param name="days"> The number of days to retain an untagged manifest after which it gets purged. </param>
        /// <param name="lastUpdatedOn"> The timestamp when the policy was last updated. </param>
        /// <param name="status"> The value that indicates whether the policy is enabled or not. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerRegistryRetentionPolicy(int? days, DateTimeOffset? lastUpdatedOn, ContainerRegistryPolicyStatus? status, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Days = days;
            LastUpdatedOn = lastUpdatedOn;
            Status = status;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The number of days to retain an untagged manifest after which it gets purged. </summary>
        [WirePath("days")]
        public int? Days { get; set; }
        /// <summary> The timestamp when the policy was last updated. </summary>
        [WirePath("lastUpdatedTime")]
        public DateTimeOffset? LastUpdatedOn { get; }
        /// <summary> The value that indicates whether the policy is enabled or not. </summary>
        [WirePath("status")]
        public ContainerRegistryPolicyStatus? Status { get; set; }
    }
}
