// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerRegistry.Models
{
    /// <summary> The resource type of the container registry. This field must be set to 'Microsoft.ContainerRegistry/registries'. </summary>
    public readonly partial struct ContainerRegistryResourceType : IEquatable<ContainerRegistryResourceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerRegistryResourceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerRegistryResourceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MicrosoftContainerRegistryRegistriesValue = "Microsoft.ContainerRegistry/registries";

        /// <summary> Microsoft.ContainerRegistry/registries. </summary>
        public static ContainerRegistryResourceType MicrosoftContainerRegistryRegistries { get; } = new ContainerRegistryResourceType(MicrosoftContainerRegistryRegistriesValue);
        /// <summary> Determines if two <see cref="ContainerRegistryResourceType"/> values are the same. </summary>
        public static bool operator ==(ContainerRegistryResourceType left, ContainerRegistryResourceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerRegistryResourceType"/> values are not the same. </summary>
        public static bool operator !=(ContainerRegistryResourceType left, ContainerRegistryResourceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerRegistryResourceType"/>. </summary>
        public static implicit operator ContainerRegistryResourceType(string value) => new ContainerRegistryResourceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerRegistryResourceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerRegistryResourceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
