// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerRegistry.Models
{
    /// <summary> Whether or not public network access is allowed for the container registry. </summary>
    public readonly partial struct ContainerRegistryPublicNetworkAccess : IEquatable<ContainerRegistryPublicNetworkAccess>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerRegistryPublicNetworkAccess"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerRegistryPublicNetworkAccess(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static ContainerRegistryPublicNetworkAccess Enabled { get; } = new ContainerRegistryPublicNetworkAccess(EnabledValue);
        /// <summary> Disabled. </summary>
        public static ContainerRegistryPublicNetworkAccess Disabled { get; } = new ContainerRegistryPublicNetworkAccess(DisabledValue);
        /// <summary> Determines if two <see cref="ContainerRegistryPublicNetworkAccess"/> values are the same. </summary>
        public static bool operator ==(ContainerRegistryPublicNetworkAccess left, ContainerRegistryPublicNetworkAccess right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerRegistryPublicNetworkAccess"/> values are not the same. </summary>
        public static bool operator !=(ContainerRegistryPublicNetworkAccess left, ContainerRegistryPublicNetworkAccess right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerRegistryPublicNetworkAccess"/>. </summary>
        public static implicit operator ContainerRegistryPublicNetworkAccess(string value) => new ContainerRegistryPublicNetworkAccess(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerRegistryPublicNetworkAccess other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerRegistryPublicNetworkAccess other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
