// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerRegistry.Models
{
    /// <summary> The private link service connection status. </summary>
    public readonly partial struct ContainerRegistryPrivateLinkServiceConnectionStatus : IEquatable<ContainerRegistryPrivateLinkServiceConnectionStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerRegistryPrivateLinkServiceConnectionStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerRegistryPrivateLinkServiceConnectionStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ApprovedValue = "Approved";
        private const string PendingValue = "Pending";
        private const string RejectedValue = "Rejected";
        private const string DisconnectedValue = "Disconnected";

        /// <summary> Approved. </summary>
        public static ContainerRegistryPrivateLinkServiceConnectionStatus Approved { get; } = new ContainerRegistryPrivateLinkServiceConnectionStatus(ApprovedValue);
        /// <summary> Pending. </summary>
        public static ContainerRegistryPrivateLinkServiceConnectionStatus Pending { get; } = new ContainerRegistryPrivateLinkServiceConnectionStatus(PendingValue);
        /// <summary> Rejected. </summary>
        public static ContainerRegistryPrivateLinkServiceConnectionStatus Rejected { get; } = new ContainerRegistryPrivateLinkServiceConnectionStatus(RejectedValue);
        /// <summary> Disconnected. </summary>
        public static ContainerRegistryPrivateLinkServiceConnectionStatus Disconnected { get; } = new ContainerRegistryPrivateLinkServiceConnectionStatus(DisconnectedValue);
        /// <summary> Determines if two <see cref="ContainerRegistryPrivateLinkServiceConnectionStatus"/> values are the same. </summary>
        public static bool operator ==(ContainerRegistryPrivateLinkServiceConnectionStatus left, ContainerRegistryPrivateLinkServiceConnectionStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerRegistryPrivateLinkServiceConnectionStatus"/> values are not the same. </summary>
        public static bool operator !=(ContainerRegistryPrivateLinkServiceConnectionStatus left, ContainerRegistryPrivateLinkServiceConnectionStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerRegistryPrivateLinkServiceConnectionStatus"/>. </summary>
        public static implicit operator ContainerRegistryPrivateLinkServiceConnectionStatus(string value) => new ContainerRegistryPrivateLinkServiceConnectionStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerRegistryPrivateLinkServiceConnectionStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerRegistryPrivateLinkServiceConnectionStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
