// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerRegistry.Models
{
    /// <summary> The value that indicates whether the policy is enabled or not. </summary>
    public readonly partial struct ContainerRegistryPolicyStatus : IEquatable<ContainerRegistryPolicyStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerRegistryPolicyStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerRegistryPolicyStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "enabled";
        private const string DisabledValue = "disabled";

        /// <summary> enabled. </summary>
        public static ContainerRegistryPolicyStatus Enabled { get; } = new ContainerRegistryPolicyStatus(EnabledValue);
        /// <summary> disabled. </summary>
        public static ContainerRegistryPolicyStatus Disabled { get; } = new ContainerRegistryPolicyStatus(DisabledValue);
        /// <summary> Determines if two <see cref="ContainerRegistryPolicyStatus"/> values are the same. </summary>
        public static bool operator ==(ContainerRegistryPolicyStatus left, ContainerRegistryPolicyStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerRegistryPolicyStatus"/> values are not the same. </summary>
        public static bool operator !=(ContainerRegistryPolicyStatus left, ContainerRegistryPolicyStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerRegistryPolicyStatus"/>. </summary>
        public static implicit operator ContainerRegistryPolicyStatus(string value) => new ContainerRegistryPolicyStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerRegistryPolicyStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerRegistryPolicyStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
