// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.ContainerRegistry.Models
{
    internal static partial class ContainerRegistryPasswordNameExtensions
    {
        public static string ToSerialString(this ContainerRegistryPasswordName value) => value switch
        {
            ContainerRegistryPasswordName.Password => "password",
            ContainerRegistryPasswordName.Password2 => "password2",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ContainerRegistryPasswordName value.")
        };

        public static ContainerRegistryPasswordName ToContainerRegistryPasswordName(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "password")) return ContainerRegistryPasswordName.Password;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "password2")) return ContainerRegistryPasswordName.Password2;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ContainerRegistryPasswordName value.");
        }
    }
}
