// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ContainerRegistry.Models
{
    /// <summary> The ContainerRegistryOverrideTaskStepProperties. </summary>
    public partial class ContainerRegistryOverrideTaskStepProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerRegistryOverrideTaskStepProperties"/>. </summary>
        public ContainerRegistryOverrideTaskStepProperties()
        {
            Arguments = new ChangeTrackingList<ContainerRegistryRunArgument>();
            Values = new ChangeTrackingList<ContainerRegistryTaskOverridableValue>();
        }

        /// <summary> Initializes a new instance of <see cref="ContainerRegistryOverrideTaskStepProperties"/>. </summary>
        /// <param name="contextPath"> The source context against which run has to be queued. </param>
        /// <param name="file"> The file against which run has to be queued. </param>
        /// <param name="arguments">
        /// Gets or sets the collection of override arguments to be used when
        /// executing a build step.
        /// </param>
        /// <param name="target"> The name of the target build stage for the docker build. </param>
        /// <param name="values"> The collection of overridable values that can be passed when running a Task. </param>
        /// <param name="updateTriggerToken"> Base64 encoded update trigger token that will be attached with the base image trigger webhook. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerRegistryOverrideTaskStepProperties(string contextPath, string file, IList<ContainerRegistryRunArgument> arguments, string target, IList<ContainerRegistryTaskOverridableValue> values, string updateTriggerToken, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ContextPath = contextPath;
            File = file;
            Arguments = arguments;
            Target = target;
            Values = values;
            UpdateTriggerToken = updateTriggerToken;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The source context against which run has to be queued. </summary>
        [WirePath("contextPath")]
        public string ContextPath { get; set; }
        /// <summary> The file against which run has to be queued. </summary>
        [WirePath("file")]
        public string File { get; set; }
        /// <summary>
        /// Gets or sets the collection of override arguments to be used when
        /// executing a build step.
        /// </summary>
        [WirePath("arguments")]
        public IList<ContainerRegistryRunArgument> Arguments { get; }
        /// <summary> The name of the target build stage for the docker build. </summary>
        [WirePath("target")]
        public string Target { get; set; }
        /// <summary> The collection of overridable values that can be passed when running a Task. </summary>
        [WirePath("values")]
        public IList<ContainerRegistryTaskOverridableValue> Values { get; }
        /// <summary> Base64 encoded update trigger token that will be attached with the base image trigger webhook. </summary>
        [WirePath("updateTriggerToken")]
        public string UpdateTriggerToken { get; set; }
    }
}
