// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerRegistry.Models
{
    /// <summary> Whether to allow trusted Azure services to access a network restricted registry. </summary>
    public readonly partial struct ContainerRegistryNetworkRuleBypassOption : IEquatable<ContainerRegistryNetworkRuleBypassOption>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerRegistryNetworkRuleBypassOption"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerRegistryNetworkRuleBypassOption(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AzureServicesValue = "AzureServices";
        private const string NoneValue = "None";

        /// <summary> AzureServices. </summary>
        public static ContainerRegistryNetworkRuleBypassOption AzureServices { get; } = new ContainerRegistryNetworkRuleBypassOption(AzureServicesValue);
        /// <summary> None. </summary>
        public static ContainerRegistryNetworkRuleBypassOption None { get; } = new ContainerRegistryNetworkRuleBypassOption(NoneValue);
        /// <summary> Determines if two <see cref="ContainerRegistryNetworkRuleBypassOption"/> values are the same. </summary>
        public static bool operator ==(ContainerRegistryNetworkRuleBypassOption left, ContainerRegistryNetworkRuleBypassOption right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerRegistryNetworkRuleBypassOption"/> values are not the same. </summary>
        public static bool operator !=(ContainerRegistryNetworkRuleBypassOption left, ContainerRegistryNetworkRuleBypassOption right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerRegistryNetworkRuleBypassOption"/>. </summary>
        public static implicit operator ContainerRegistryNetworkRuleBypassOption(string value) => new ContainerRegistryNetworkRuleBypassOption(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerRegistryNetworkRuleBypassOption other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerRegistryNetworkRuleBypassOption other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
