// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ContainerRegistry.Models
{
    /// <summary> The ContainerRegistryKeyVaultProperties. </summary>
    public partial class ContainerRegistryKeyVaultProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerRegistryKeyVaultProperties"/>. </summary>
        public ContainerRegistryKeyVaultProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ContainerRegistryKeyVaultProperties"/>. </summary>
        /// <param name="keyIdentifier"> Key vault uri to access the encryption key. </param>
        /// <param name="versionedKeyIdentifier"> The fully qualified key identifier that includes the version of the key that is actually used for encryption. </param>
        /// <param name="identity"> The client id of the identity which will be used to access key vault. </param>
        /// <param name="isKeyRotationEnabled"> Auto key rotation status for a CMK enabled registry. </param>
        /// <param name="lastKeyRotationTimestamp"> Timestamp of the last successful key rotation. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerRegistryKeyVaultProperties(string keyIdentifier, string versionedKeyIdentifier, string identity, bool? isKeyRotationEnabled, DateTimeOffset? lastKeyRotationTimestamp, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            KeyIdentifier = keyIdentifier;
            VersionedKeyIdentifier = versionedKeyIdentifier;
            Identity = identity;
            IsKeyRotationEnabled = isKeyRotationEnabled;
            LastKeyRotationTimestamp = lastKeyRotationTimestamp;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Key vault uri to access the encryption key. </summary>
        [WirePath("keyIdentifier")]
        public string KeyIdentifier { get; set; }
        /// <summary> The fully qualified key identifier that includes the version of the key that is actually used for encryption. </summary>
        [WirePath("versionedKeyIdentifier")]
        public string VersionedKeyIdentifier { get; }
        /// <summary> The client id of the identity which will be used to access key vault. </summary>
        [WirePath("identity")]
        public string Identity { get; set; }
        /// <summary> Auto key rotation status for a CMK enabled registry. </summary>
        [WirePath("keyRotationEnabled")]
        public bool? IsKeyRotationEnabled { get; }
        /// <summary> Timestamp of the last successful key rotation. </summary>
        [WirePath("lastKeyRotationTimestamp")]
        public DateTimeOffset? LastKeyRotationTimestamp { get; }
    }
}
