// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerRegistry.Models
{
    /// <summary> When Force, any existing target tags will be overwritten. When NoForce, any existing target tags will fail the operation before any copying begins. </summary>
    public readonly partial struct ContainerRegistryImportMode : IEquatable<ContainerRegistryImportMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerRegistryImportMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerRegistryImportMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoForceValue = "NoForce";
        private const string ForceValue = "Force";

        /// <summary> NoForce. </summary>
        public static ContainerRegistryImportMode NoForce { get; } = new ContainerRegistryImportMode(NoForceValue);
        /// <summary> Force. </summary>
        public static ContainerRegistryImportMode Force { get; } = new ContainerRegistryImportMode(ForceValue);
        /// <summary> Determines if two <see cref="ContainerRegistryImportMode"/> values are the same. </summary>
        public static bool operator ==(ContainerRegistryImportMode left, ContainerRegistryImportMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerRegistryImportMode"/> values are not the same. </summary>
        public static bool operator !=(ContainerRegistryImportMode left, ContainerRegistryImportMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerRegistryImportMode"/>. </summary>
        public static implicit operator ContainerRegistryImportMode(string value) => new ContainerRegistryImportMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerRegistryImportMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerRegistryImportMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
