// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ContainerRegistry.Models
{
    /// <summary> The image update trigger that caused a build. </summary>
    public partial class ContainerRegistryImageUpdateTrigger
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerRegistryImageUpdateTrigger"/>. </summary>
        public ContainerRegistryImageUpdateTrigger()
        {
            Images = new ChangeTrackingList<ContainerRegistryImageDescriptor>();
        }

        /// <summary> Initializes a new instance of <see cref="ContainerRegistryImageUpdateTrigger"/>. </summary>
        /// <param name="id"> The unique ID of the trigger. </param>
        /// <param name="timestamp"> The timestamp when the image update happened. </param>
        /// <param name="images"> The list of image updates that caused the build. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerRegistryImageUpdateTrigger(Guid? id, DateTimeOffset? timestamp, IList<ContainerRegistryImageDescriptor> images, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            Timestamp = timestamp;
            Images = images;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The unique ID of the trigger. </summary>
        [WirePath("id")]
        public Guid? Id { get; set; }
        /// <summary> The timestamp when the image update happened. </summary>
        [WirePath("timestamp")]
        public DateTimeOffset? Timestamp { get; set; }
        /// <summary> The list of image updates that caused the build. </summary>
        [WirePath("images")]
        public IList<ContainerRegistryImageDescriptor> Images { get; }
    }
}
