// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ContainerRegistry.Models
{
    /// <summary> Properties for a registry image. </summary>
    public partial class ContainerRegistryImageDescriptor
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerRegistryImageDescriptor"/>. </summary>
        public ContainerRegistryImageDescriptor()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ContainerRegistryImageDescriptor"/>. </summary>
        /// <param name="registry"> The registry login server. </param>
        /// <param name="repository"> The repository name. </param>
        /// <param name="tag"> The tag name. </param>
        /// <param name="digest"> The sha256-based digest of the image manifest. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerRegistryImageDescriptor(string registry, string repository, string tag, string digest, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Registry = registry;
            Repository = repository;
            Tag = tag;
            Digest = digest;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The registry login server. </summary>
        [WirePath("registry")]
        public string Registry { get; set; }
        /// <summary> The repository name. </summary>
        [WirePath("repository")]
        public string Repository { get; set; }
        /// <summary> The tag name. </summary>
        [WirePath("tag")]
        public string Tag { get; set; }
        /// <summary> The sha256-based digest of the image manifest. </summary>
        [WirePath("digest")]
        public string Digest { get; set; }
    }
}
