// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerRegistry.Models
{
    /// <summary> The value that indicates whether the policy is enabled or not. </summary>
    public readonly partial struct ContainerRegistryExportPolicyStatus : IEquatable<ContainerRegistryExportPolicyStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerRegistryExportPolicyStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerRegistryExportPolicyStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "enabled";
        private const string DisabledValue = "disabled";

        /// <summary> enabled. </summary>
        public static ContainerRegistryExportPolicyStatus Enabled { get; } = new ContainerRegistryExportPolicyStatus(EnabledValue);
        /// <summary> disabled. </summary>
        public static ContainerRegistryExportPolicyStatus Disabled { get; } = new ContainerRegistryExportPolicyStatus(DisabledValue);
        /// <summary> Determines if two <see cref="ContainerRegistryExportPolicyStatus"/> values are the same. </summary>
        public static bool operator ==(ContainerRegistryExportPolicyStatus left, ContainerRegistryExportPolicyStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerRegistryExportPolicyStatus"/> values are not the same. </summary>
        public static bool operator !=(ContainerRegistryExportPolicyStatus left, ContainerRegistryExportPolicyStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerRegistryExportPolicyStatus"/>. </summary>
        public static implicit operator ContainerRegistryExportPolicyStatus(string value) => new ContainerRegistryExportPolicyStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerRegistryExportPolicyStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerRegistryExportPolicyStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
