// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ContainerRegistry.Models
{
    /// <summary> The properties for updating a docker build step. </summary>
    public partial class ContainerRegistryDockerBuildStepUpdateContent : ContainerRegistryTaskStepUpdateContent
    {
        /// <summary> Initializes a new instance of <see cref="ContainerRegistryDockerBuildStepUpdateContent"/>. </summary>
        public ContainerRegistryDockerBuildStepUpdateContent()
        {
            ImageNames = new ChangeTrackingList<string>();
            Arguments = new ChangeTrackingList<ContainerRegistryRunArgument>();
            StepType = ContainerRegistryTaskStepType.Docker;
        }

        /// <summary> Initializes a new instance of <see cref="ContainerRegistryDockerBuildStepUpdateContent"/>. </summary>
        /// <param name="stepType"> The type of the step. </param>
        /// <param name="contextPath"> The URL(absolute or relative) of the source context for the task step. </param>
        /// <param name="contextAccessToken"> The token (git PAT or SAS token of storage account blob) associated with the context for a step. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="imageNames"> The fully qualified image names including the repository and tag. </param>
        /// <param name="isPushEnabled"> The value of this property indicates whether the image built should be pushed to the registry or not. </param>
        /// <param name="noCache"> The value of this property indicates whether the image cache is enabled or not. </param>
        /// <param name="dockerFilePath"> The Docker file path relative to the source context. </param>
        /// <param name="arguments"> The collection of override arguments to be used when executing this build step. </param>
        /// <param name="target"> The name of the target build stage for the docker build. </param>
        internal ContainerRegistryDockerBuildStepUpdateContent(ContainerRegistryTaskStepType stepType, string contextPath, string contextAccessToken, IDictionary<string, BinaryData> serializedAdditionalRawData, IList<string> imageNames, bool? isPushEnabled, bool? noCache, string dockerFilePath, IList<ContainerRegistryRunArgument> arguments, string target) : base(stepType, contextPath, contextAccessToken, serializedAdditionalRawData)
        {
            ImageNames = imageNames;
            IsPushEnabled = isPushEnabled;
            NoCache = noCache;
            DockerFilePath = dockerFilePath;
            Arguments = arguments;
            Target = target;
            StepType = stepType;
        }

        /// <summary> The fully qualified image names including the repository and tag. </summary>
        [WirePath("imageNames")]
        public IList<string> ImageNames { get; }
        /// <summary> The value of this property indicates whether the image built should be pushed to the registry or not. </summary>
        [WirePath("isPushEnabled")]
        public bool? IsPushEnabled { get; set; }
        /// <summary> The value of this property indicates whether the image cache is enabled or not. </summary>
        [WirePath("noCache")]
        public bool? NoCache { get; set; }
        /// <summary> The Docker file path relative to the source context. </summary>
        [WirePath("dockerFilePath")]
        public string DockerFilePath { get; set; }
        /// <summary> The collection of override arguments to be used when executing this build step. </summary>
        [WirePath("arguments")]
        public IList<ContainerRegistryRunArgument> Arguments { get; }
        /// <summary> The name of the target build stage for the docker build. </summary>
        [WirePath("target")]
        public string Target { get; set; }
    }
}
