// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerRegistry.Models
{
    /// <summary> Variant of the CPU. </summary>
    public readonly partial struct ContainerRegistryCpuVariant : IEquatable<ContainerRegistryCpuVariant>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerRegistryCpuVariant"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerRegistryCpuVariant(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string V6Value = "v6";
        private const string V7Value = "v7";
        private const string V8Value = "v8";

        /// <summary> v6. </summary>
        public static ContainerRegistryCpuVariant V6 { get; } = new ContainerRegistryCpuVariant(V6Value);
        /// <summary> v7. </summary>
        public static ContainerRegistryCpuVariant V7 { get; } = new ContainerRegistryCpuVariant(V7Value);
        /// <summary> v8. </summary>
        public static ContainerRegistryCpuVariant V8 { get; } = new ContainerRegistryCpuVariant(V8Value);
        /// <summary> Determines if two <see cref="ContainerRegistryCpuVariant"/> values are the same. </summary>
        public static bool operator ==(ContainerRegistryCpuVariant left, ContainerRegistryCpuVariant right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerRegistryCpuVariant"/> values are not the same. </summary>
        public static bool operator !=(ContainerRegistryCpuVariant left, ContainerRegistryCpuVariant right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerRegistryCpuVariant"/>. </summary>
        public static implicit operator ContainerRegistryCpuVariant(string value) => new ContainerRegistryCpuVariant(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerRegistryCpuVariant other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerRegistryCpuVariant other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
