// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ContainerRegistry.Models
{
    /// <summary> The trigger based on base image dependency. </summary>
    public partial class ContainerRegistryBaseImageTrigger
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerRegistryBaseImageTrigger"/>. </summary>
        /// <param name="baseImageTriggerType"> The type of the auto trigger for base image dependency updates. </param>
        /// <param name="name"> The name of the trigger. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> is null. </exception>
        public ContainerRegistryBaseImageTrigger(ContainerRegistryBaseImageTriggerType baseImageTriggerType, string name)
        {
            Argument.AssertNotNull(name, nameof(name));

            BaseImageTriggerType = baseImageTriggerType;
            Name = name;
        }

        /// <summary> Initializes a new instance of <see cref="ContainerRegistryBaseImageTrigger"/>. </summary>
        /// <param name="baseImageTriggerType"> The type of the auto trigger for base image dependency updates. </param>
        /// <param name="updateTriggerEndpoint"> The endpoint URL for receiving update triggers. </param>
        /// <param name="updateTriggerPayloadType"> Type of Payload body for Base image update triggers. </param>
        /// <param name="status"> The current status of trigger. </param>
        /// <param name="name"> The name of the trigger. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerRegistryBaseImageTrigger(ContainerRegistryBaseImageTriggerType baseImageTriggerType, string updateTriggerEndpoint, ContainerRegistryUpdateTriggerPayloadType? updateTriggerPayloadType, ContainerRegistryTriggerStatus? status, string name, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            BaseImageTriggerType = baseImageTriggerType;
            UpdateTriggerEndpoint = updateTriggerEndpoint;
            UpdateTriggerPayloadType = updateTriggerPayloadType;
            Status = status;
            Name = name;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ContainerRegistryBaseImageTrigger"/> for deserialization. </summary>
        internal ContainerRegistryBaseImageTrigger()
        {
        }

        /// <summary> The type of the auto trigger for base image dependency updates. </summary>
        [WirePath("baseImageTriggerType")]
        public ContainerRegistryBaseImageTriggerType BaseImageTriggerType { get; set; }
        /// <summary> The endpoint URL for receiving update triggers. </summary>
        [WirePath("updateTriggerEndpoint")]
        public string UpdateTriggerEndpoint { get; set; }
        /// <summary> Type of Payload body for Base image update triggers. </summary>
        [WirePath("updateTriggerPayloadType")]
        public ContainerRegistryUpdateTriggerPayloadType? UpdateTriggerPayloadType { get; set; }
        /// <summary> The current status of trigger. </summary>
        [WirePath("status")]
        public ContainerRegistryTriggerStatus? Status { get; set; }
        /// <summary> The name of the trigger. </summary>
        [WirePath("name")]
        public string Name { get; set; }
    }
}
