// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerRegistry.Models
{
    /// <summary> A message indicating if changes on the service provider require any updates on the consumer. </summary>
    public readonly partial struct ActionsRequiredForPrivateLinkServiceConsumer : IEquatable<ActionsRequiredForPrivateLinkServiceConsumer>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ActionsRequiredForPrivateLinkServiceConsumer"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ActionsRequiredForPrivateLinkServiceConsumer(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string RecreateValue = "Recreate";

        /// <summary> None. </summary>
        public static ActionsRequiredForPrivateLinkServiceConsumer None { get; } = new ActionsRequiredForPrivateLinkServiceConsumer(NoneValue);
        /// <summary> Recreate. </summary>
        public static ActionsRequiredForPrivateLinkServiceConsumer Recreate { get; } = new ActionsRequiredForPrivateLinkServiceConsumer(RecreateValue);
        /// <summary> Determines if two <see cref="ActionsRequiredForPrivateLinkServiceConsumer"/> values are the same. </summary>
        public static bool operator ==(ActionsRequiredForPrivateLinkServiceConsumer left, ActionsRequiredForPrivateLinkServiceConsumer right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ActionsRequiredForPrivateLinkServiceConsumer"/> values are not the same. </summary>
        public static bool operator !=(ActionsRequiredForPrivateLinkServiceConsumer left, ActionsRequiredForPrivateLinkServiceConsumer right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ActionsRequiredForPrivateLinkServiceConsumer"/>. </summary>
        public static implicit operator ActionsRequiredForPrivateLinkServiceConsumer(string value) => new ActionsRequiredForPrivateLinkServiceConsumer(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ActionsRequiredForPrivateLinkServiceConsumer other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ActionsRequiredForPrivateLinkServiceConsumer other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
