// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ContainerRegistry
{
    internal class ScopeMapOperationSource : IOperationSource<ScopeMapResource>
    {
        private readonly ArmClient _client;

        internal ScopeMapOperationSource(ArmClient client)
        {
            _client = client;
        }

        ScopeMapResource IOperationSource<ScopeMapResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ScopeMapData.DeserializeScopeMapData(document.RootElement);
            return new ScopeMapResource(_client, data);
        }

        async ValueTask<ScopeMapResource> IOperationSource<ScopeMapResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ScopeMapData.DeserializeScopeMapData(document.RootElement);
            return new ScopeMapResource(_client, data);
        }
    }
}
