// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ContainerRegistry
{
    internal class ContainerRegistryRunOperationSource : IOperationSource<ContainerRegistryRunResource>
    {
        private readonly ArmClient _client;

        internal ContainerRegistryRunOperationSource(ArmClient client)
        {
            _client = client;
        }

        ContainerRegistryRunResource IOperationSource<ContainerRegistryRunResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ContainerRegistryRunData.DeserializeContainerRegistryRunData(document.RootElement);
            return new ContainerRegistryRunResource(_client, data);
        }

        async ValueTask<ContainerRegistryRunResource> IOperationSource<ContainerRegistryRunResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ContainerRegistryRunData.DeserializeContainerRegistryRunData(document.RootElement);
            return new ContainerRegistryRunResource(_client, data);
        }
    }
}
