// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ContainerRegistry
{
    internal class ContainerRegistryReplicationOperationSource : IOperationSource<ContainerRegistryReplicationResource>
    {
        private readonly ArmClient _client;

        internal ContainerRegistryReplicationOperationSource(ArmClient client)
        {
            _client = client;
        }

        ContainerRegistryReplicationResource IOperationSource<ContainerRegistryReplicationResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ContainerRegistryReplicationData.DeserializeContainerRegistryReplicationData(document.RootElement);
            return new ContainerRegistryReplicationResource(_client, data);
        }

        async ValueTask<ContainerRegistryReplicationResource> IOperationSource<ContainerRegistryReplicationResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ContainerRegistryReplicationData.DeserializeContainerRegistryReplicationData(document.RootElement);
            return new ContainerRegistryReplicationResource(_client, data);
        }
    }
}
