// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ContainerRegistry
{
    internal class ContainerRegistryOperationSource : IOperationSource<ContainerRegistryResource>
    {
        private readonly ArmClient _client;

        internal ContainerRegistryOperationSource(ArmClient client)
        {
            _client = client;
        }

        ContainerRegistryResource IOperationSource<ContainerRegistryResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ContainerRegistryData.DeserializeContainerRegistryData(document.RootElement);
            return new ContainerRegistryResource(_client, data);
        }

        async ValueTask<ContainerRegistryResource> IOperationSource<ContainerRegistryResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ContainerRegistryData.DeserializeContainerRegistryData(document.RootElement);
            return new ContainerRegistryResource(_client, data);
        }
    }
}
