// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.ContainerRegistry.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableContainerRegistryArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableContainerRegistryArmClient"/> class for mocking. </summary>
        protected MockableContainerRegistryArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableContainerRegistryArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableContainerRegistryArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableContainerRegistryArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="ContainerRegistryResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ContainerRegistryResource.CreateResourceIdentifier" /> to create a <see cref="ContainerRegistryResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ContainerRegistryResource"/> object. </returns>
        public virtual ContainerRegistryResource GetContainerRegistryResource(ResourceIdentifier id)
        {
            ContainerRegistryResource.ValidateResourceId(id);
            return new ContainerRegistryResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ContainerRegistryPrivateLinkResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ContainerRegistryPrivateLinkResource.CreateResourceIdentifier" /> to create a <see cref="ContainerRegistryPrivateLinkResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ContainerRegistryPrivateLinkResource"/> object. </returns>
        public virtual ContainerRegistryPrivateLinkResource GetContainerRegistryPrivateLinkResource(ResourceIdentifier id)
        {
            ContainerRegistryPrivateLinkResource.ValidateResourceId(id);
            return new ContainerRegistryPrivateLinkResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ContainerRegistryPrivateEndpointConnectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ContainerRegistryPrivateEndpointConnectionResource.CreateResourceIdentifier" /> to create a <see cref="ContainerRegistryPrivateEndpointConnectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ContainerRegistryPrivateEndpointConnectionResource"/> object. </returns>
        public virtual ContainerRegistryPrivateEndpointConnectionResource GetContainerRegistryPrivateEndpointConnectionResource(ResourceIdentifier id)
        {
            ContainerRegistryPrivateEndpointConnectionResource.ValidateResourceId(id);
            return new ContainerRegistryPrivateEndpointConnectionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ContainerRegistryReplicationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ContainerRegistryReplicationResource.CreateResourceIdentifier" /> to create a <see cref="ContainerRegistryReplicationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ContainerRegistryReplicationResource"/> object. </returns>
        public virtual ContainerRegistryReplicationResource GetContainerRegistryReplicationResource(ResourceIdentifier id)
        {
            ContainerRegistryReplicationResource.ValidateResourceId(id);
            return new ContainerRegistryReplicationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ScopeMapResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ScopeMapResource.CreateResourceIdentifier" /> to create a <see cref="ScopeMapResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ScopeMapResource"/> object. </returns>
        public virtual ScopeMapResource GetScopeMapResource(ResourceIdentifier id)
        {
            ScopeMapResource.ValidateResourceId(id);
            return new ScopeMapResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ContainerRegistryTokenResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ContainerRegistryTokenResource.CreateResourceIdentifier" /> to create a <see cref="ContainerRegistryTokenResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ContainerRegistryTokenResource"/> object. </returns>
        public virtual ContainerRegistryTokenResource GetContainerRegistryTokenResource(ResourceIdentifier id)
        {
            ContainerRegistryTokenResource.ValidateResourceId(id);
            return new ContainerRegistryTokenResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ContainerRegistryWebhookResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ContainerRegistryWebhookResource.CreateResourceIdentifier" /> to create a <see cref="ContainerRegistryWebhookResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ContainerRegistryWebhookResource"/> object. </returns>
        public virtual ContainerRegistryWebhookResource GetContainerRegistryWebhookResource(ResourceIdentifier id)
        {
            ContainerRegistryWebhookResource.ValidateResourceId(id);
            return new ContainerRegistryWebhookResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ContainerRegistryAgentPoolResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ContainerRegistryAgentPoolResource.CreateResourceIdentifier" /> to create a <see cref="ContainerRegistryAgentPoolResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ContainerRegistryAgentPoolResource"/> object. </returns>
        public virtual ContainerRegistryAgentPoolResource GetContainerRegistryAgentPoolResource(ResourceIdentifier id)
        {
            ContainerRegistryAgentPoolResource.ValidateResourceId(id);
            return new ContainerRegistryAgentPoolResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ContainerRegistryRunResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ContainerRegistryRunResource.CreateResourceIdentifier" /> to create a <see cref="ContainerRegistryRunResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ContainerRegistryRunResource"/> object. </returns>
        public virtual ContainerRegistryRunResource GetContainerRegistryRunResource(ResourceIdentifier id)
        {
            ContainerRegistryRunResource.ValidateResourceId(id);
            return new ContainerRegistryRunResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ContainerRegistryTaskRunResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ContainerRegistryTaskRunResource.CreateResourceIdentifier" /> to create a <see cref="ContainerRegistryTaskRunResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ContainerRegistryTaskRunResource"/> object. </returns>
        public virtual ContainerRegistryTaskRunResource GetContainerRegistryTaskRunResource(ResourceIdentifier id)
        {
            ContainerRegistryTaskRunResource.ValidateResourceId(id);
            return new ContainerRegistryTaskRunResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ContainerRegistryTaskResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ContainerRegistryTaskResource.CreateResourceIdentifier" /> to create a <see cref="ContainerRegistryTaskResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ContainerRegistryTaskResource"/> object. </returns>
        public virtual ContainerRegistryTaskResource GetContainerRegistryTaskResource(ResourceIdentifier id)
        {
            ContainerRegistryTaskResource.ValidateResourceId(id);
            return new ContainerRegistryTaskResource(Client, id);
        }
    }
}
