// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.ContainerRegistry.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.ContainerRegistry
{
    /// <summary>
    /// A class representing the ContainerRegistryTask data model.
    /// The task that has the ARM resource and task properties.
    /// The task will have all information to schedule a run against it.
    /// </summary>
    public partial class ContainerRegistryTaskData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerRegistryTaskData"/>. </summary>
        /// <param name="location"> The location. </param>
        public ContainerRegistryTaskData(AzureLocation location) : base(location)
        {
        }

        /// <summary> Initializes a new instance of <see cref="ContainerRegistryTaskData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="identity"> Identity for the resource. </param>
        /// <param name="provisioningState"> The provisioning state of the task. </param>
        /// <param name="createdOn"> The creation date of task. </param>
        /// <param name="status"> The current status of task. </param>
        /// <param name="platform"> The platform properties against which the run has to happen. </param>
        /// <param name="agentConfiguration"> The machine configuration of the run agent. </param>
        /// <param name="agentPoolName"> The dedicated agent pool for the task. </param>
        /// <param name="timeoutInSeconds"> Run timeout in seconds. </param>
        /// <param name="step">
        /// The properties of a task step.
        /// Please note <see cref="ContainerRegistryTaskStepProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ContainerRegistryDockerBuildStep"/>, <see cref="ContainerRegistryEncodedTaskStep"/> and <see cref="ContainerRegistryFileTaskStep"/>.
        /// </param>
        /// <param name="trigger"> The properties that describe all triggers for the task. </param>
        /// <param name="credentials"> The properties that describes a set of credentials that will be used when this run is invoked. </param>
        /// <param name="logTemplate"> The template that describes the repository and tag information for run log artifact. </param>
        /// <param name="isSystemTask"> The value of this property indicates whether the task resource is system task or not. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerRegistryTaskData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, ManagedServiceIdentity identity, ContainerRegistryProvisioningState? provisioningState, DateTimeOffset? createdOn, ContainerRegistryTaskStatus? status, ContainerRegistryPlatformProperties platform, ContainerRegistryAgentProperties agentConfiguration, string agentPoolName, int? timeoutInSeconds, ContainerRegistryTaskStepProperties step, ContainerRegistryTriggerProperties trigger, ContainerRegistryCredentials credentials, string logTemplate, bool? isSystemTask, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            Identity = identity;
            ProvisioningState = provisioningState;
            CreatedOn = createdOn;
            Status = status;
            Platform = platform;
            AgentConfiguration = agentConfiguration;
            AgentPoolName = agentPoolName;
            TimeoutInSeconds = timeoutInSeconds;
            Step = step;
            Trigger = trigger;
            Credentials = credentials;
            LogTemplate = logTemplate;
            IsSystemTask = isSystemTask;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ContainerRegistryTaskData"/> for deserialization. </summary>
        internal ContainerRegistryTaskData()
        {
        }

        /// <summary> Identity for the resource. </summary>
        [WirePath("identity")]
        public ManagedServiceIdentity Identity { get; set; }
        /// <summary> The provisioning state of the task. </summary>
        [WirePath("properties.provisioningState")]
        public ContainerRegistryProvisioningState? ProvisioningState { get; }
        /// <summary> The creation date of task. </summary>
        [WirePath("properties.creationDate")]
        public DateTimeOffset? CreatedOn { get; }
        /// <summary> The current status of task. </summary>
        [WirePath("properties.status")]
        public ContainerRegistryTaskStatus? Status { get; set; }
        /// <summary> The platform properties against which the run has to happen. </summary>
        [WirePath("properties.platform")]
        public ContainerRegistryPlatformProperties Platform { get; set; }
        /// <summary> The machine configuration of the run agent. </summary>
        internal ContainerRegistryAgentProperties AgentConfiguration { get; set; }
        /// <summary> The CPU configuration in terms of number of cores required for the run. </summary>
        [WirePath("properties.agentConfiguration.cpu")]
        public int? AgentCpu
        {
            get => AgentConfiguration is null ? default : AgentConfiguration.Cpu;
            set
            {
                if (AgentConfiguration is null)
                    AgentConfiguration = new ContainerRegistryAgentProperties();
                AgentConfiguration.Cpu = value;
            }
        }

        /// <summary> The dedicated agent pool for the task. </summary>
        [WirePath("properties.agentPoolName")]
        public string AgentPoolName { get; set; }
        /// <summary> Run timeout in seconds. </summary>
        [WirePath("properties.timeout")]
        public int? TimeoutInSeconds { get; set; }
        /// <summary>
        /// The properties of a task step.
        /// Please note <see cref="ContainerRegistryTaskStepProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ContainerRegistryDockerBuildStep"/>, <see cref="ContainerRegistryEncodedTaskStep"/> and <see cref="ContainerRegistryFileTaskStep"/>.
        /// </summary>
        [WirePath("properties.step")]
        public ContainerRegistryTaskStepProperties Step { get; set; }
        /// <summary> The properties that describe all triggers for the task. </summary>
        [WirePath("properties.trigger")]
        public ContainerRegistryTriggerProperties Trigger { get; set; }
        /// <summary> The properties that describes a set of credentials that will be used when this run is invoked. </summary>
        [WirePath("properties.credentials")]
        public ContainerRegistryCredentials Credentials { get; set; }
        /// <summary> The template that describes the repository and tag information for run log artifact. </summary>
        [WirePath("properties.logTemplate")]
        public string LogTemplate { get; set; }
        /// <summary> The value of this property indicates whether the task resource is system task or not. </summary>
        [WirePath("properties.isSystemTask")]
        public bool? IsSystemTask { get; set; }
    }
}
