// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.ContainerRegistry.Models;

namespace Azure.ResourceManager.ContainerRegistry.Samples
{
    public partial class Sample_ContainerRegistryTaskResource
    {
        // Tasks_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_TasksGet()
        {
            // Generated from example definition: specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2019-06-01-preview/examples/TasksGet.json
            // this example is just showing the usage of "Tasks_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerRegistryTaskResource created on azure
            // for more information of creating ContainerRegistryTaskResource, please refer to the document of ContainerRegistryTaskResource
            string subscriptionId = "4385cf00-2d3a-425a-832f-f4285b1c9dce";
            string resourceGroupName = "myResourceGroup";
            string registryName = "myRegistry";
            string taskName = "myTask";
            ResourceIdentifier containerRegistryTaskResourceId = ContainerRegistryTaskResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, registryName, taskName);
            ContainerRegistryTaskResource containerRegistryTask = client.GetContainerRegistryTaskResource(containerRegistryTaskResourceId);

            // invoke the operation
            ContainerRegistryTaskResource result = await containerRegistryTask.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerRegistryTaskData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Tasks_Delete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_TasksDelete()
        {
            // Generated from example definition: specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2019-06-01-preview/examples/TasksDelete.json
            // this example is just showing the usage of "Tasks_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerRegistryTaskResource created on azure
            // for more information of creating ContainerRegistryTaskResource, please refer to the document of ContainerRegistryTaskResource
            string subscriptionId = "4385cf00-2d3a-425a-832f-f4285b1c9dce";
            string resourceGroupName = "myResourceGroup";
            string registryName = "myRegistry";
            string taskName = "myTask";
            ResourceIdentifier containerRegistryTaskResourceId = ContainerRegistryTaskResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, registryName, taskName);
            ContainerRegistryTaskResource containerRegistryTask = client.GetContainerRegistryTaskResource(containerRegistryTaskResourceId);

            // invoke the operation
            await containerRegistryTask.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Tasks_Update
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_TasksUpdate()
        {
            // Generated from example definition: specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2019-06-01-preview/examples/TasksUpdate.json
            // this example is just showing the usage of "Tasks_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerRegistryTaskResource created on azure
            // for more information of creating ContainerRegistryTaskResource, please refer to the document of ContainerRegistryTaskResource
            string subscriptionId = "4385cf00-2d3a-425a-832f-f4285b1c9dce";
            string resourceGroupName = "myResourceGroup";
            string registryName = "myRegistry";
            string taskName = "myTask";
            ResourceIdentifier containerRegistryTaskResourceId = ContainerRegistryTaskResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, registryName, taskName);
            ContainerRegistryTaskResource containerRegistryTask = client.GetContainerRegistryTaskResource(containerRegistryTaskResourceId);

            // invoke the operation
            ContainerRegistryTaskPatch patch = new ContainerRegistryTaskPatch()
            {
                Tags =
{
["testkey"] = "value",
},
                Status = ContainerRegistryTaskStatus.Enabled,
                AgentCpu = 3,
                Step = new ContainerRegistryDockerBuildStepUpdateContent()
                {
                    ImageNames =
{
"azurerest:testtag1"
},
                    DockerFilePath = "src/DockerFile",
                },
                Trigger = new ContainerRegistryTriggerUpdateContent()
                {
                    SourceTriggers =
{
new ContainerRegistrySourceTriggerUpdateContent("mySourceTrigger")
{
SourceRepository = new SourceCodeRepoUpdateContent()
{
SourceControlAuthProperties = new SourceCodeRepoAuthInfoUpdateContent()
{
TokenType = SourceCodeRepoAuthTokenType.Pat,
Token = "xxxxx",
},
},
SourceTriggerEvents =
{
ContainerRegistrySourceTriggerEvent.Commit
},
}
},
                },
                Credentials = new ContainerRegistryCredentials()
                {
                    CustomRegistries =
{
["myregistry.azurecr.io"] = new CustomRegistryCredentials()
{
UserName = new ContainerRegistrySecretObject()
{
Value = "username",
ObjectType = ContainerRegistrySecretObjectType.Opaque,
},
Password = new ContainerRegistrySecretObject()
{
Value = "https://myacbvault.vault.azure.net/secrets/password",
ObjectType = ContainerRegistrySecretObjectType.VaultSecret,
},
Identity = "[system]",
},
},
                },
                LogTemplate = "acr/tasks:{{.Run.OS}}",
            };
            ArmOperation<ContainerRegistryTaskResource> lro = await containerRegistryTask.UpdateAsync(WaitUntil.Completed, patch);
            ContainerRegistryTaskResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerRegistryTaskData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Tasks_Update_QuickTask
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_TasksUpdateQuickTask()
        {
            // Generated from example definition: specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2019-06-01-preview/examples/TasksUpdate_QuickTask.json
            // this example is just showing the usage of "Tasks_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerRegistryTaskResource created on azure
            // for more information of creating ContainerRegistryTaskResource, please refer to the document of ContainerRegistryTaskResource
            string subscriptionId = "4385cf00-2d3a-425a-832f-f4285b1c9dce";
            string resourceGroupName = "myResourceGroup";
            string registryName = "myRegistry";
            string taskName = "quicktask";
            ResourceIdentifier containerRegistryTaskResourceId = ContainerRegistryTaskResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, registryName, taskName);
            ContainerRegistryTaskResource containerRegistryTask = client.GetContainerRegistryTaskResource(containerRegistryTaskResourceId);

            // invoke the operation
            ContainerRegistryTaskPatch patch = new ContainerRegistryTaskPatch()
            {
                Tags =
{
["testkey"] = "value",
},
                Status = ContainerRegistryTaskStatus.Enabled,
                LogTemplate = "acr/tasks:{{.Run.OS}}",
            };
            ArmOperation<ContainerRegistryTaskResource> lro = await containerRegistryTask.UpdateAsync(WaitUntil.Completed, patch);
            ContainerRegistryTaskResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerRegistryTaskData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Tasks_Update_WithKeyVaultCustomCredentials
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_TasksUpdateWithKeyVaultCustomCredentials()
        {
            // Generated from example definition: specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2019-06-01-preview/examples/ManagedIdentity/TasksUpdate_WithKeyVaultCustomCredentials.json
            // this example is just showing the usage of "Tasks_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerRegistryTaskResource created on azure
            // for more information of creating ContainerRegistryTaskResource, please refer to the document of ContainerRegistryTaskResource
            string subscriptionId = "4385cf00-2d3a-425a-832f-f4285b1c9dce";
            string resourceGroupName = "myResourceGroup";
            string registryName = "myRegistry";
            string taskName = "myTask";
            ResourceIdentifier containerRegistryTaskResourceId = ContainerRegistryTaskResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, registryName, taskName);
            ContainerRegistryTaskResource containerRegistryTask = client.GetContainerRegistryTaskResource(containerRegistryTaskResourceId);

            // invoke the operation
            ContainerRegistryTaskPatch patch = new ContainerRegistryTaskPatch()
            {
                Tags =
{
["testkey"] = "value",
},
                Status = ContainerRegistryTaskStatus.Enabled,
                AgentCpu = 3,
                Step = new ContainerRegistryDockerBuildStepUpdateContent()
                {
                    ImageNames =
{
"azurerest:testtag1"
},
                    DockerFilePath = "src/DockerFile",
                },
                Trigger = new ContainerRegistryTriggerUpdateContent()
                {
                    SourceTriggers =
{
new ContainerRegistrySourceTriggerUpdateContent("mySourceTrigger")
{
SourceRepository = new SourceCodeRepoUpdateContent()
{
SourceControlAuthProperties = new SourceCodeRepoAuthInfoUpdateContent()
{
TokenType = SourceCodeRepoAuthTokenType.Pat,
Token = "xxxxx",
},
},
SourceTriggerEvents =
{
ContainerRegistrySourceTriggerEvent.Commit
},
}
},
                },
                Credentials = new ContainerRegistryCredentials()
                {
                    CustomRegistries =
{
["myregistry.azurecr.io"] = new CustomRegistryCredentials()
{
UserName = new ContainerRegistrySecretObject()
{
Value = "https://myacbvault.vault.azure.net/secrets/username",
ObjectType = ContainerRegistrySecretObjectType.VaultSecret,
},
Password = new ContainerRegistrySecretObject()
{
Value = "https://myacbvault.vault.azure.net/secrets/password",
ObjectType = ContainerRegistrySecretObjectType.VaultSecret,
},
Identity = "[system]",
},
},
                },
                LogTemplate = null,
            };
            ArmOperation<ContainerRegistryTaskResource> lro = await containerRegistryTask.UpdateAsync(WaitUntil.Completed, patch);
            ContainerRegistryTaskResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerRegistryTaskData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Tasks_Update_WithMSICustomCredentials
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_TasksUpdateWithMSICustomCredentials()
        {
            // Generated from example definition: specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2019-06-01-preview/examples/ManagedIdentity/TasksUpdate_WithMSICustomCredentials.json
            // this example is just showing the usage of "Tasks_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerRegistryTaskResource created on azure
            // for more information of creating ContainerRegistryTaskResource, please refer to the document of ContainerRegistryTaskResource
            string subscriptionId = "4385cf00-2d3a-425a-832f-f4285b1c9dce";
            string resourceGroupName = "myResourceGroup";
            string registryName = "myRegistry";
            string taskName = "myTask";
            ResourceIdentifier containerRegistryTaskResourceId = ContainerRegistryTaskResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, registryName, taskName);
            ContainerRegistryTaskResource containerRegistryTask = client.GetContainerRegistryTaskResource(containerRegistryTaskResourceId);

            // invoke the operation
            ContainerRegistryTaskPatch patch = new ContainerRegistryTaskPatch()
            {
                Tags =
{
["testkey"] = "value",
},
                Status = ContainerRegistryTaskStatus.Enabled,
                AgentCpu = 3,
                Step = new ContainerRegistryDockerBuildStepUpdateContent()
                {
                    ImageNames =
{
"azurerest:testtag1"
},
                    DockerFilePath = "src/DockerFile",
                },
                Trigger = new ContainerRegistryTriggerUpdateContent()
                {
                    SourceTriggers =
{
new ContainerRegistrySourceTriggerUpdateContent("mySourceTrigger")
{
SourceRepository = new SourceCodeRepoUpdateContent()
{
SourceControlAuthProperties = new SourceCodeRepoAuthInfoUpdateContent()
{
TokenType = SourceCodeRepoAuthTokenType.Pat,
Token = "xxxxx",
},
},
SourceTriggerEvents =
{
ContainerRegistrySourceTriggerEvent.Commit
},
}
},
                },
                Credentials = new ContainerRegistryCredentials()
                {
                    CustomRegistries =
{
["myregistry.azurecr.io"] = new CustomRegistryCredentials()
{
Identity = "[system]",
},
},
                },
                LogTemplate = null,
            };
            ArmOperation<ContainerRegistryTaskResource> lro = await containerRegistryTask.UpdateAsync(WaitUntil.Completed, patch);
            ContainerRegistryTaskResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerRegistryTaskData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Tasks_Update_WithOpaqueCustomCredentials
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_TasksUpdateWithOpaqueCustomCredentials()
        {
            // Generated from example definition: specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2019-06-01-preview/examples/TasksUpdate_WithOpaqueCustomCredentials.json
            // this example is just showing the usage of "Tasks_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerRegistryTaskResource created on azure
            // for more information of creating ContainerRegistryTaskResource, please refer to the document of ContainerRegistryTaskResource
            string subscriptionId = "4385cf00-2d3a-425a-832f-f4285b1c9dce";
            string resourceGroupName = "myResourceGroup";
            string registryName = "myRegistry";
            string taskName = "myTask";
            ResourceIdentifier containerRegistryTaskResourceId = ContainerRegistryTaskResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, registryName, taskName);
            ContainerRegistryTaskResource containerRegistryTask = client.GetContainerRegistryTaskResource(containerRegistryTaskResourceId);

            // invoke the operation
            ContainerRegistryTaskPatch patch = new ContainerRegistryTaskPatch()
            {
                Tags =
{
["testkey"] = "value",
},
                Status = ContainerRegistryTaskStatus.Enabled,
                AgentCpu = 3,
                Step = new ContainerRegistryDockerBuildStepUpdateContent()
                {
                    ImageNames =
{
"azurerest:testtag1"
},
                    DockerFilePath = "src/DockerFile",
                },
                Trigger = new ContainerRegistryTriggerUpdateContent()
                {
                    SourceTriggers =
{
new ContainerRegistrySourceTriggerUpdateContent("mySourceTrigger")
{
SourceRepository = new SourceCodeRepoUpdateContent()
{
SourceControlAuthProperties = new SourceCodeRepoAuthInfoUpdateContent()
{
TokenType = SourceCodeRepoAuthTokenType.Pat,
Token = "xxxxx",
},
},
SourceTriggerEvents =
{
ContainerRegistrySourceTriggerEvent.Commit
},
}
},
                },
                Credentials = new ContainerRegistryCredentials()
                {
                    CustomRegistries =
{
["myregistry.azurecr.io"] = new CustomRegistryCredentials()
{
UserName = new ContainerRegistrySecretObject()
{
Value = "username",
ObjectType = ContainerRegistrySecretObjectType.Opaque,
},
Password = new ContainerRegistrySecretObject()
{
Value = "***",
ObjectType = ContainerRegistrySecretObjectType.Opaque,
},
},
},
                },
                LogTemplate = null,
            };
            ArmOperation<ContainerRegistryTaskResource> lro = await containerRegistryTask.UpdateAsync(WaitUntil.Completed, patch);
            ContainerRegistryTaskResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerRegistryTaskData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Tasks_GetDetails
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetDetails_TasksGetDetails()
        {
            // Generated from example definition: specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2019-06-01-preview/examples/TasksGetDetails.json
            // this example is just showing the usage of "Tasks_GetDetails" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerRegistryTaskResource created on azure
            // for more information of creating ContainerRegistryTaskResource, please refer to the document of ContainerRegistryTaskResource
            string subscriptionId = "4385cf00-2d3a-425a-832f-f4285b1c9dce";
            string resourceGroupName = "myResourceGroup";
            string registryName = "myRegistry";
            string taskName = "myTask";
            ResourceIdentifier containerRegistryTaskResourceId = ContainerRegistryTaskResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, registryName, taskName);
            ContainerRegistryTaskResource containerRegistryTask = client.GetContainerRegistryTaskResource(containerRegistryTaskResourceId);

            // invoke the operation
            ContainerRegistryTaskResource result = await containerRegistryTask.GetDetailsAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerRegistryTaskData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
