// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.ContainerRegistry.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.ContainerRegistry.Samples
{
    public partial class Sample_ContainerRegistryTaskCollection
    {
        // Tasks_List
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_TasksList()
        {
            // Generated from example definition: specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2019-06-01-preview/examples/TasksList.json
            // this example is just showing the usage of "Tasks_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerRegistryResource created on azure
            // for more information of creating ContainerRegistryResource, please refer to the document of ContainerRegistryResource
            string subscriptionId = "4385cf00-2d3a-425a-832f-f4285b1c9dce";
            string resourceGroupName = "myResourceGroup";
            string registryName = "myRegistry";
            ResourceIdentifier containerRegistryResourceId = ContainerRegistryResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, registryName);
            ContainerRegistryResource containerRegistry = client.GetContainerRegistryResource(containerRegistryResourceId);

            // get the collection of this ContainerRegistryTaskResource
            ContainerRegistryTaskCollection collection = containerRegistry.GetContainerRegistryTasks();

            // invoke the operation and iterate over the result
            await foreach (ContainerRegistryTaskResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ContainerRegistryTaskData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Tasks_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_TasksGet()
        {
            // Generated from example definition: specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2019-06-01-preview/examples/TasksGet.json
            // this example is just showing the usage of "Tasks_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerRegistryResource created on azure
            // for more information of creating ContainerRegistryResource, please refer to the document of ContainerRegistryResource
            string subscriptionId = "4385cf00-2d3a-425a-832f-f4285b1c9dce";
            string resourceGroupName = "myResourceGroup";
            string registryName = "myRegistry";
            ResourceIdentifier containerRegistryResourceId = ContainerRegistryResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, registryName);
            ContainerRegistryResource containerRegistry = client.GetContainerRegistryResource(containerRegistryResourceId);

            // get the collection of this ContainerRegistryTaskResource
            ContainerRegistryTaskCollection collection = containerRegistry.GetContainerRegistryTasks();

            // invoke the operation
            string taskName = "myTask";
            ContainerRegistryTaskResource result = await collection.GetAsync(taskName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerRegistryTaskData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Tasks_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_TasksGet()
        {
            // Generated from example definition: specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2019-06-01-preview/examples/TasksGet.json
            // this example is just showing the usage of "Tasks_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerRegistryResource created on azure
            // for more information of creating ContainerRegistryResource, please refer to the document of ContainerRegistryResource
            string subscriptionId = "4385cf00-2d3a-425a-832f-f4285b1c9dce";
            string resourceGroupName = "myResourceGroup";
            string registryName = "myRegistry";
            ResourceIdentifier containerRegistryResourceId = ContainerRegistryResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, registryName);
            ContainerRegistryResource containerRegistry = client.GetContainerRegistryResource(containerRegistryResourceId);

            // get the collection of this ContainerRegistryTaskResource
            ContainerRegistryTaskCollection collection = containerRegistry.GetContainerRegistryTasks();

            // invoke the operation
            string taskName = "myTask";
            bool result = await collection.ExistsAsync(taskName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Tasks_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_TasksGet()
        {
            // Generated from example definition: specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2019-06-01-preview/examples/TasksGet.json
            // this example is just showing the usage of "Tasks_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerRegistryResource created on azure
            // for more information of creating ContainerRegistryResource, please refer to the document of ContainerRegistryResource
            string subscriptionId = "4385cf00-2d3a-425a-832f-f4285b1c9dce";
            string resourceGroupName = "myResourceGroup";
            string registryName = "myRegistry";
            ResourceIdentifier containerRegistryResourceId = ContainerRegistryResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, registryName);
            ContainerRegistryResource containerRegistry = client.GetContainerRegistryResource(containerRegistryResourceId);

            // get the collection of this ContainerRegistryTaskResource
            ContainerRegistryTaskCollection collection = containerRegistry.GetContainerRegistryTasks();

            // invoke the operation
            string taskName = "myTask";
            NullableResponse<ContainerRegistryTaskResource> response = await collection.GetIfExistsAsync(taskName);
            ContainerRegistryTaskResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ContainerRegistryTaskData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Tasks_Create
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_TasksCreate()
        {
            // Generated from example definition: specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2019-06-01-preview/examples/TasksCreate.json
            // this example is just showing the usage of "Tasks_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerRegistryResource created on azure
            // for more information of creating ContainerRegistryResource, please refer to the document of ContainerRegistryResource
            string subscriptionId = "4385cf00-2d3a-425a-832f-f4285b1c9dce";
            string resourceGroupName = "myResourceGroup";
            string registryName = "myRegistry";
            ResourceIdentifier containerRegistryResourceId = ContainerRegistryResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, registryName);
            ContainerRegistryResource containerRegistry = client.GetContainerRegistryResource(containerRegistryResourceId);

            // get the collection of this ContainerRegistryTaskResource
            ContainerRegistryTaskCollection collection = containerRegistry.GetContainerRegistryTasks();

            // invoke the operation
            string taskName = "mytTask";
            ContainerRegistryTaskData data = new ContainerRegistryTaskData(new AzureLocation("eastus"))
            {
                Identity = new ManagedServiceIdentity("SystemAssigned"),
                Status = ContainerRegistryTaskStatus.Enabled,
                Platform = new ContainerRegistryPlatformProperties(ContainerRegistryOS.Linux)
                {
                    Architecture = ContainerRegistryOSArchitecture.Amd64,
                },
                AgentCpu = 2,
                Step = new ContainerRegistryDockerBuildStep("src/DockerFile")
                {
                    ImageNames =
{
"azurerest:testtag"
},
                    IsPushEnabled = true,
                    NoCache = false,
                    Arguments =
{
new ContainerRegistryRunArgument("mytestargument","mytestvalue")
{
IsSecret = false,
},new ContainerRegistryRunArgument("mysecrettestargument","mysecrettestvalue")
{
IsSecret = true,
}
},
                    ContextPath = "src",
                },
                Trigger = new ContainerRegistryTriggerProperties()
                {
                    TimerTriggers =
{
new ContainerRegistryTimerTrigger("30 9 * * 1-5","myTimerTrigger")
},
                    SourceTriggers =
{
new ContainerRegistrySourceTrigger(new SourceCodeRepoProperties(SourceControlType.Github,new Uri("https://github.com/Azure/azure-rest-api-specs"))
{
Branch = "master",
SourceControlAuthProperties = new SourceCodeRepoAuthInfo(SourceCodeRepoAuthTokenType.Pat,"xxxxx"),
},new ContainerRegistrySourceTriggerEvent[]
{
ContainerRegistrySourceTriggerEvent.Commit
},"mySourceTrigger")
},
                    BaseImageTrigger = new ContainerRegistryBaseImageTrigger(ContainerRegistryBaseImageTriggerType.Runtime, "myBaseImageTrigger")
                    {
                        UpdateTriggerEndpoint = "https://user:pass@mycicd.webhook.com?token=foo",
                        UpdateTriggerPayloadType = ContainerRegistryUpdateTriggerPayloadType.Token,
                    },
                },
                LogTemplate = "acr/tasks:{{.Run.OS}}",
                IsSystemTask = false,
                Tags =
{
["testkey"] = "value",
},
            };
            ArmOperation<ContainerRegistryTaskResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, taskName, data);
            ContainerRegistryTaskResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerRegistryTaskData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Tasks_Create_QuickTask
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_TasksCreateQuickTask()
        {
            // Generated from example definition: specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2019-06-01-preview/examples/TasksCreate_QuickTask.json
            // this example is just showing the usage of "Tasks_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerRegistryResource created on azure
            // for more information of creating ContainerRegistryResource, please refer to the document of ContainerRegistryResource
            string subscriptionId = "4385cf00-2d3a-425a-832f-f4285b1c9dce";
            string resourceGroupName = "myResourceGroup";
            string registryName = "myRegistry";
            ResourceIdentifier containerRegistryResourceId = ContainerRegistryResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, registryName);
            ContainerRegistryResource containerRegistry = client.GetContainerRegistryResource(containerRegistryResourceId);

            // get the collection of this ContainerRegistryTaskResource
            ContainerRegistryTaskCollection collection = containerRegistry.GetContainerRegistryTasks();

            // invoke the operation
            string taskName = "quicktask";
            ContainerRegistryTaskData data = new ContainerRegistryTaskData(new AzureLocation("eastus"))
            {
                Identity = null,
                Status = ContainerRegistryTaskStatus.Enabled,
                LogTemplate = "acr/tasks:{{.Run.OS}}",
                IsSystemTask = true,
                Tags =
{
["testkey"] = "value",
},
            };
            ArmOperation<ContainerRegistryTaskResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, taskName, data);
            ContainerRegistryTaskResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerRegistryTaskData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Tasks_Create_WithSystemAndUserIdentities
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_TasksCreateWithSystemAndUserIdentities()
        {
            // Generated from example definition: specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2019-06-01-preview/examples/ManagedIdentity/TasksCreate_WithSystemAndUserIdentities.json
            // this example is just showing the usage of "Tasks_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerRegistryResource created on azure
            // for more information of creating ContainerRegistryResource, please refer to the document of ContainerRegistryResource
            string subscriptionId = "4385cf00-2d3a-425a-832f-f4285b1c9dce";
            string resourceGroupName = "myResourceGroup";
            string registryName = "myRegistry";
            ResourceIdentifier containerRegistryResourceId = ContainerRegistryResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, registryName);
            ContainerRegistryResource containerRegistry = client.GetContainerRegistryResource(containerRegistryResourceId);

            // get the collection of this ContainerRegistryTaskResource
            ContainerRegistryTaskCollection collection = containerRegistry.GetContainerRegistryTasks();

            // invoke the operation
            string taskName = "mytTask";
            ContainerRegistryTaskData data = new ContainerRegistryTaskData(new AzureLocation("eastus"))
            {
                Identity = new ManagedServiceIdentity("SystemAssigned, UserAssigned")
                {
                    UserAssignedIdentities =
{
[new ResourceIdentifier("/subscriptions/f9d7ebed-adbd-4cb4-b973-aaf82c136138/resourcegroups/myResourceGroup1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity2")] = new UserAssignedIdentity(),
},
                },
                Status = ContainerRegistryTaskStatus.Enabled,
                Platform = new ContainerRegistryPlatformProperties(ContainerRegistryOS.Linux)
                {
                    Architecture = ContainerRegistryOSArchitecture.Amd64,
                },
                AgentCpu = 2,
                Step = new ContainerRegistryDockerBuildStep("src/DockerFile")
                {
                    ImageNames =
{
"azurerest:testtag"
},
                    IsPushEnabled = true,
                    NoCache = false,
                    Arguments =
{
new ContainerRegistryRunArgument("mytestargument","mytestvalue")
{
IsSecret = false,
},new ContainerRegistryRunArgument("mysecrettestargument","mysecrettestvalue")
{
IsSecret = true,
}
},
                    ContextPath = "src",
                },
                Trigger = new ContainerRegistryTriggerProperties()
                {
                    TimerTriggers =
{
new ContainerRegistryTimerTrigger("30 9 * * 1-5","myTimerTrigger")
},
                    SourceTriggers =
{
new ContainerRegistrySourceTrigger(new SourceCodeRepoProperties(SourceControlType.Github,new Uri("https://github.com/Azure/azure-rest-api-specs"))
{
Branch = "master",
SourceControlAuthProperties = new SourceCodeRepoAuthInfo(SourceCodeRepoAuthTokenType.Pat,"xxxxx"),
},new ContainerRegistrySourceTriggerEvent[]
{
ContainerRegistrySourceTriggerEvent.Commit
},"mySourceTrigger")
},
                    BaseImageTrigger = new ContainerRegistryBaseImageTrigger(ContainerRegistryBaseImageTriggerType.Runtime, "myBaseImageTrigger")
                    {
                        UpdateTriggerEndpoint = "https://user:pass@mycicd.webhook.com?token=foo",
                        UpdateTriggerPayloadType = ContainerRegistryUpdateTriggerPayloadType.Default,
                    },
                },
                LogTemplate = null,
                IsSystemTask = false,
                Tags =
{
["testkey"] = "value",
},
            };
            ArmOperation<ContainerRegistryTaskResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, taskName, data);
            ContainerRegistryTaskResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerRegistryTaskData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Tasks_Create_WithUserIdentities
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_TasksCreateWithUserIdentities()
        {
            // Generated from example definition: specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2019-06-01-preview/examples/ManagedIdentity/TasksCreate_WithUserIdentities.json
            // this example is just showing the usage of "Tasks_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerRegistryResource created on azure
            // for more information of creating ContainerRegistryResource, please refer to the document of ContainerRegistryResource
            string subscriptionId = "4385cf00-2d3a-425a-832f-f4285b1c9dce";
            string resourceGroupName = "myResourceGroup";
            string registryName = "myRegistry";
            ResourceIdentifier containerRegistryResourceId = ContainerRegistryResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, registryName);
            ContainerRegistryResource containerRegistry = client.GetContainerRegistryResource(containerRegistryResourceId);

            // get the collection of this ContainerRegistryTaskResource
            ContainerRegistryTaskCollection collection = containerRegistry.GetContainerRegistryTasks();

            // invoke the operation
            string taskName = "mytTask";
            ContainerRegistryTaskData data = new ContainerRegistryTaskData(new AzureLocation("eastus"))
            {
                Identity = new ManagedServiceIdentity("UserAssigned")
                {
                    UserAssignedIdentities =
{
[new ResourceIdentifier("/subscriptions/f9d7ebed-adbd-4cb4-b973-aaf82c136138/resourcegroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity1")] = new UserAssignedIdentity(),
[new ResourceIdentifier("/subscriptions/f9d7ebed-adbd-4cb4-b973-aaf82c136138/resourcegroups/myResourceGroup1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity2")] = new UserAssignedIdentity(),
},
                },
                Status = ContainerRegistryTaskStatus.Enabled,
                Platform = new ContainerRegistryPlatformProperties(ContainerRegistryOS.Linux)
                {
                    Architecture = ContainerRegistryOSArchitecture.Amd64,
                },
                AgentCpu = 2,
                Step = new ContainerRegistryDockerBuildStep("src/DockerFile")
                {
                    ImageNames =
{
"azurerest:testtag"
},
                    IsPushEnabled = true,
                    NoCache = false,
                    Arguments =
{
new ContainerRegistryRunArgument("mytestargument","mytestvalue")
{
IsSecret = false,
},new ContainerRegistryRunArgument("mysecrettestargument","mysecrettestvalue")
{
IsSecret = true,
}
},
                    ContextPath = "src",
                },
                Trigger = new ContainerRegistryTriggerProperties()
                {
                    TimerTriggers =
{
new ContainerRegistryTimerTrigger("30 9 * * 1-5","myTimerTrigger")
},
                    SourceTriggers =
{
new ContainerRegistrySourceTrigger(new SourceCodeRepoProperties(SourceControlType.Github,new Uri("https://github.com/Azure/azure-rest-api-specs"))
{
Branch = "master",
SourceControlAuthProperties = new SourceCodeRepoAuthInfo(SourceCodeRepoAuthTokenType.Pat,"xxxxx"),
},new ContainerRegistrySourceTriggerEvent[]
{
ContainerRegistrySourceTriggerEvent.Commit
},"mySourceTrigger")
},
                    BaseImageTrigger = new ContainerRegistryBaseImageTrigger(ContainerRegistryBaseImageTriggerType.Runtime, "myBaseImageTrigger")
                    {
                        UpdateTriggerEndpoint = "https://user:pass@mycicd.webhook.com?token=foo",
                        UpdateTriggerPayloadType = ContainerRegistryUpdateTriggerPayloadType.Default,
                    },
                },
                LogTemplate = null,
                IsSystemTask = false,
                Tags =
{
["testkey"] = "value",
},
            };
            ArmOperation<ContainerRegistryTaskResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, taskName, data);
            ContainerRegistryTaskResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerRegistryTaskData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Tasks_Create_WithUserIdentities_WithSystemIdentity
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_TasksCreateWithUserIdentitiesWithSystemIdentity()
        {
            // Generated from example definition: specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2019-06-01-preview/examples/ManagedIdentity/TasksCreate_WithSystemIdentity.json
            // this example is just showing the usage of "Tasks_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerRegistryResource created on azure
            // for more information of creating ContainerRegistryResource, please refer to the document of ContainerRegistryResource
            string subscriptionId = "4385cf00-2d3a-425a-832f-f4285b1c9dce";
            string resourceGroupName = "myResourceGroup";
            string registryName = "myRegistry";
            ResourceIdentifier containerRegistryResourceId = ContainerRegistryResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, registryName);
            ContainerRegistryResource containerRegistry = client.GetContainerRegistryResource(containerRegistryResourceId);

            // get the collection of this ContainerRegistryTaskResource
            ContainerRegistryTaskCollection collection = containerRegistry.GetContainerRegistryTasks();

            // invoke the operation
            string taskName = "mytTask";
            ContainerRegistryTaskData data = new ContainerRegistryTaskData(new AzureLocation("eastus"))
            {
                Identity = new ManagedServiceIdentity("SystemAssigned"),
                Status = ContainerRegistryTaskStatus.Enabled,
                Platform = new ContainerRegistryPlatformProperties(ContainerRegistryOS.Linux)
                {
                    Architecture = ContainerRegistryOSArchitecture.Amd64,
                },
                AgentCpu = 2,
                Step = new ContainerRegistryDockerBuildStep("src/DockerFile")
                {
                    ImageNames =
{
"azurerest:testtag"
},
                    IsPushEnabled = true,
                    NoCache = false,
                    Arguments =
{
new ContainerRegistryRunArgument("mytestargument","mytestvalue")
{
IsSecret = false,
},new ContainerRegistryRunArgument("mysecrettestargument","mysecrettestvalue")
{
IsSecret = true,
}
},
                    ContextPath = "src",
                },
                Trigger = new ContainerRegistryTriggerProperties()
                {
                    TimerTriggers =
{
new ContainerRegistryTimerTrigger("30 9 * * 1-5","myTimerTrigger")
},
                    SourceTriggers =
{
new ContainerRegistrySourceTrigger(new SourceCodeRepoProperties(SourceControlType.Github,new Uri("https://github.com/Azure/azure-rest-api-specs"))
{
Branch = "master",
SourceControlAuthProperties = new SourceCodeRepoAuthInfo(SourceCodeRepoAuthTokenType.Pat,"xxxxx"),
},new ContainerRegistrySourceTriggerEvent[]
{
ContainerRegistrySourceTriggerEvent.Commit
},"mySourceTrigger")
},
                    BaseImageTrigger = new ContainerRegistryBaseImageTrigger(ContainerRegistryBaseImageTriggerType.Runtime, "myBaseImageTrigger"),
                },
                LogTemplate = null,
                IsSystemTask = false,
                Tags =
{
["testkey"] = "value",
},
            };
            ArmOperation<ContainerRegistryTaskResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, taskName, data);
            ContainerRegistryTaskResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerRegistryTaskData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
