// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.ContainerRegistry.Models;

namespace Azure.ResourceManager.ContainerRegistry.Samples
{
    public partial class Sample_ContainerRegistryRunResource
    {
        // Runs_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_RunsGet()
        {
            // Generated from example definition: specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2019-06-01-preview/examples/RunsGet.json
            // this example is just showing the usage of "Runs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerRegistryRunResource created on azure
            // for more information of creating ContainerRegistryRunResource, please refer to the document of ContainerRegistryRunResource
            string subscriptionId = "4385cf00-2d3a-425a-832f-f4285b1c9dce";
            string resourceGroupName = "myResourceGroup";
            string registryName = "myRegistry";
            string runId = "0accec26-d6de-4757-8e74-d080f38eaaab";
            ResourceIdentifier containerRegistryRunResourceId = ContainerRegistryRunResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, registryName, runId);
            ContainerRegistryRunResource containerRegistryRun = client.GetContainerRegistryRunResource(containerRegistryRunResourceId);

            // invoke the operation
            ContainerRegistryRunResource result = await containerRegistryRun.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerRegistryRunData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Runs_Update
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_RunsUpdate()
        {
            // Generated from example definition: specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2019-06-01-preview/examples/RunsUpdate.json
            // this example is just showing the usage of "Runs_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerRegistryRunResource created on azure
            // for more information of creating ContainerRegistryRunResource, please refer to the document of ContainerRegistryRunResource
            string subscriptionId = "4385cf00-2d3a-425a-832f-f4285b1c9dce";
            string resourceGroupName = "myResourceGroup";
            string registryName = "myRegistry";
            string runId = "0accec26-d6de-4757-8e74-d080f38eaaab";
            ResourceIdentifier containerRegistryRunResourceId = ContainerRegistryRunResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, registryName, runId);
            ContainerRegistryRunResource containerRegistryRun = client.GetContainerRegistryRunResource(containerRegistryRunResourceId);

            // invoke the operation
            ContainerRegistryRunPatch patch = new ContainerRegistryRunPatch()
            {
                IsArchiveEnabled = true,
            };
            ArmOperation<ContainerRegistryRunResource> lro = await containerRegistryRun.UpdateAsync(WaitUntil.Completed, patch);
            ContainerRegistryRunResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerRegistryRunData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Runs_GetLogSasUrl
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetLogSasUrl_RunsGetLogSasUrl()
        {
            // Generated from example definition: specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2019-06-01-preview/examples/RunsGetLogSasUrl.json
            // this example is just showing the usage of "Runs_GetLogSasUrl" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerRegistryRunResource created on azure
            // for more information of creating ContainerRegistryRunResource, please refer to the document of ContainerRegistryRunResource
            string subscriptionId = "4385cf00-2d3a-425a-832f-f4285b1c9dce";
            string resourceGroupName = "myResourceGroup";
            string registryName = "myRegistry";
            string runId = "0accec26-d6de-4757-8e74-d080f38eaaab";
            ResourceIdentifier containerRegistryRunResourceId = ContainerRegistryRunResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, registryName, runId);
            ContainerRegistryRunResource containerRegistryRun = client.GetContainerRegistryRunResource(containerRegistryRunResourceId);

            // invoke the operation
            ContainerRegistryRunGetLogResult result = await containerRegistryRun.GetLogSasUrlAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // Runs_Cancel
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Cancel_RunsCancel()
        {
            // Generated from example definition: specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2019-06-01-preview/examples/RunsCancel.json
            // this example is just showing the usage of "Runs_Cancel" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerRegistryRunResource created on azure
            // for more information of creating ContainerRegistryRunResource, please refer to the document of ContainerRegistryRunResource
            string subscriptionId = "4385cf00-2d3a-425a-832f-f4285b1c9dce";
            string resourceGroupName = "myResourceGroup";
            string registryName = "myRegistry";
            string runId = "0accec26-d6de-4757-8e74-d080f38eaaab";
            ResourceIdentifier containerRegistryRunResourceId = ContainerRegistryRunResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, registryName, runId);
            ContainerRegistryRunResource containerRegistryRun = client.GetContainerRegistryRunResource(containerRegistryRunResourceId);

            // invoke the operation
            await containerRegistryRun.CancelAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
