// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.ContainerRegistry.Models;

namespace Azure.ResourceManager.ContainerRegistry.Samples
{
    public partial class Sample_ContainerRegistryPrivateEndpointConnectionResource
    {
        // PrivateEndpointConnectionGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_PrivateEndpointConnectionGet()
        {
            // Generated from example definition: specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/stable/2022-12-01/examples/PrivateEndpointConnectionGet.json
            // this example is just showing the usage of "PrivateEndpointConnections_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerRegistryPrivateEndpointConnectionResource created on azure
            // for more information of creating ContainerRegistryPrivateEndpointConnectionResource, please refer to the document of ContainerRegistryPrivateEndpointConnectionResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string registryName = "myRegistry";
            string privateEndpointConnectionName = "myConnection";
            ResourceIdentifier containerRegistryPrivateEndpointConnectionResourceId = ContainerRegistryPrivateEndpointConnectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, registryName, privateEndpointConnectionName);
            ContainerRegistryPrivateEndpointConnectionResource containerRegistryPrivateEndpointConnection = client.GetContainerRegistryPrivateEndpointConnectionResource(containerRegistryPrivateEndpointConnectionResourceId);

            // invoke the operation
            ContainerRegistryPrivateEndpointConnectionResource result = await containerRegistryPrivateEndpointConnection.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerRegistryPrivateEndpointConnectionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // PrivateEndpointConnectionCreateOrUpdate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_PrivateEndpointConnectionCreateOrUpdate()
        {
            // Generated from example definition: specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/stable/2022-12-01/examples/PrivateEndpointConnectionCreateOrUpdate.json
            // this example is just showing the usage of "PrivateEndpointConnections_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerRegistryPrivateEndpointConnectionResource created on azure
            // for more information of creating ContainerRegistryPrivateEndpointConnectionResource, please refer to the document of ContainerRegistryPrivateEndpointConnectionResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string registryName = "myRegistry";
            string privateEndpointConnectionName = "myConnection";
            ResourceIdentifier containerRegistryPrivateEndpointConnectionResourceId = ContainerRegistryPrivateEndpointConnectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, registryName, privateEndpointConnectionName);
            ContainerRegistryPrivateEndpointConnectionResource containerRegistryPrivateEndpointConnection = client.GetContainerRegistryPrivateEndpointConnectionResource(containerRegistryPrivateEndpointConnectionResourceId);

            // invoke the operation
            ContainerRegistryPrivateEndpointConnectionData data = new ContainerRegistryPrivateEndpointConnectionData()
            {
                ConnectionState = new ContainerRegistryPrivateLinkServiceConnectionState()
                {
                    Status = ContainerRegistryPrivateLinkServiceConnectionStatus.Approved,
                    Description = "Auto-Approved",
                },
            };
            ArmOperation<ContainerRegistryPrivateEndpointConnectionResource> lro = await containerRegistryPrivateEndpointConnection.UpdateAsync(WaitUntil.Completed, data);
            ContainerRegistryPrivateEndpointConnectionResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerRegistryPrivateEndpointConnectionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // PrivateEndpointConnectionDelete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_PrivateEndpointConnectionDelete()
        {
            // Generated from example definition: specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/stable/2022-12-01/examples/PrivateEndpointConnectionDelete.json
            // this example is just showing the usage of "PrivateEndpointConnections_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerRegistryPrivateEndpointConnectionResource created on azure
            // for more information of creating ContainerRegistryPrivateEndpointConnectionResource, please refer to the document of ContainerRegistryPrivateEndpointConnectionResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string registryName = "myRegistry";
            string privateEndpointConnectionName = "myConnection";
            ResourceIdentifier containerRegistryPrivateEndpointConnectionResourceId = ContainerRegistryPrivateEndpointConnectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, registryName, privateEndpointConnectionName);
            ContainerRegistryPrivateEndpointConnectionResource containerRegistryPrivateEndpointConnection = client.GetContainerRegistryPrivateEndpointConnectionResource(containerRegistryPrivateEndpointConnectionResourceId);

            // invoke the operation
            await containerRegistryPrivateEndpointConnection.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
