// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Containers.ContainerRegistry
{
    internal static partial class TokenGrantTypeExtensions
    {
        public static string ToSerialString(this TokenGrantType value) => value switch
        {
            TokenGrantType.RefreshToken => "refresh_token",
            TokenGrantType.Password => "password",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown TokenGrantType value.")
        };

        public static TokenGrantType ToTokenGrantType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "refresh_token")) return TokenGrantType.RefreshToken;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "password")) return TokenGrantType.Password;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown TokenGrantType value.");
        }
    }
}
