// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.Containers.ContainerRegistry
{
    internal partial class TagList
    {
        internal static TagList DeserializeTagList(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string registry = default;
            string imageName = default;
            IReadOnlyList<TagAttributesBase> tags = default;
            string link = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("registry"u8))
                {
                    registry = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("imageName"u8))
                {
                    imageName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("tags"u8))
                {
                    List<TagAttributesBase> array = new List<TagAttributesBase>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(TagAttributesBase.DeserializeTagAttributesBase(item));
                    }
                    tags = array;
                    continue;
                }
                if (property.NameEquals("link"u8))
                {
                    link = property.Value.GetString();
                    continue;
                }
            }
            return new TagList(registry, imageName, tags, link);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static TagList FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeTagList(document.RootElement);
        }
    }
}
