// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.Containers.ContainerRegistry
{
    internal partial class Platform
    {
        internal static Platform DeserializePlatform(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string architecture = default;
            string os = default;
            string osVersion = default;
            IReadOnlyList<string> osFeatures = default;
            string variant = default;
            IReadOnlyList<string> features = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("architecture"u8))
                {
                    architecture = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("os"u8))
                {
                    os = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("os.version"u8))
                {
                    osVersion = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("os.features"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    osFeatures = array;
                    continue;
                }
                if (property.NameEquals("variant"u8))
                {
                    variant = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("features"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    features = array;
                    continue;
                }
            }
            return new Platform(
                architecture,
                os,
                osVersion,
                osFeatures ?? new ChangeTrackingList<string>(),
                variant,
                features ?? new ChangeTrackingList<string>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static Platform FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializePlatform(document.RootElement);
        }
    }
}
