// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Containers.ContainerRegistry
{
    /// <summary> Returns the requested OCI Manifest file. </summary>
    public partial class OciImageManifest
    {
        /// <summary> Initializes a new instance of <see cref="OciImageManifest"/>. </summary>
        /// <param name="schemaVersion"> Schema version. </param>
        public OciImageManifest(int schemaVersion)
        {
            Layers = new ChangeTrackingList<OciDescriptor>();
            SchemaVersion = schemaVersion;
        }

        /// <summary> Initializes a new instance of <see cref="OciImageManifest"/>. </summary>
        /// <param name="configuration"> V2 image config descriptor. </param>
        /// <param name="layers"> List of V2 image layer information. </param>
        /// <param name="annotations"> Additional information provided through arbitrary metadata. </param>
        /// <param name="schemaVersion"> Schema version. </param>
        internal OciImageManifest(OciDescriptor configuration, IList<OciDescriptor> layers, OciAnnotations annotations, int schemaVersion)
        {
            Configuration = configuration;
            Layers = layers;
            Annotations = annotations;
            SchemaVersion = schemaVersion;
        }

        /// <summary> V2 image config descriptor. </summary>
        public OciDescriptor Configuration { get; set; }
        /// <summary> List of V2 image layer information. </summary>
        public IList<OciDescriptor> Layers { get; }
        /// <summary> Additional information provided through arbitrary metadata. </summary>
        public OciAnnotations Annotations { get; set; }
        /// <summary> Schema version. </summary>
        public int SchemaVersion { get; set; }
    }
}
