// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Containers.ContainerRegistry
{
    public partial class OciAnnotations : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            if (Optional.IsDefined(CreatedOn))
            {
                writer.WritePropertyName("org.opencontainers.image.created"u8);
                writer.WriteStringValue(CreatedOn.Value, "O");
            }
            if (Optional.IsDefined(Authors))
            {
                writer.WritePropertyName("org.opencontainers.image.authors"u8);
                writer.WriteStringValue(Authors);
            }
            if (Optional.IsDefined(Url))
            {
                writer.WritePropertyName("org.opencontainers.image.url"u8);
                writer.WriteStringValue(Url.AbsoluteUri);
            }
            if (Optional.IsDefined(Documentation))
            {
                writer.WritePropertyName("org.opencontainers.image.documentation"u8);
                writer.WriteStringValue(Documentation.AbsoluteUri);
            }
            if (Optional.IsDefined(Source))
            {
                writer.WritePropertyName("org.opencontainers.image.source"u8);
                writer.WriteStringValue(Source.AbsoluteUri);
            }
            if (Optional.IsDefined(Version))
            {
                writer.WritePropertyName("org.opencontainers.image.version"u8);
                writer.WriteStringValue(Version);
            }
            if (Optional.IsDefined(Revision))
            {
                writer.WritePropertyName("org.opencontainers.image.revision"u8);
                writer.WriteStringValue(Revision);
            }
            if (Optional.IsDefined(Vendor))
            {
                writer.WritePropertyName("org.opencontainers.image.vendor"u8);
                writer.WriteStringValue(Vendor);
            }
            if (Optional.IsDefined(Licenses))
            {
                writer.WritePropertyName("org.opencontainers.image.licenses"u8);
                writer.WriteStringValue(Licenses);
            }
            if (Optional.IsDefined(Name))
            {
                writer.WritePropertyName("org.opencontainers.image.ref.name"u8);
                writer.WriteStringValue(Name);
            }
            if (Optional.IsDefined(Title))
            {
                writer.WritePropertyName("org.opencontainers.image.title"u8);
                writer.WriteStringValue(Title);
            }
            if (Optional.IsDefined(Description))
            {
                writer.WritePropertyName("org.opencontainers.image.description"u8);
                writer.WriteStringValue(Description);
            }
            foreach (var item in AdditionalProperties)
            {
                writer.WritePropertyName(item.Key);
                writer.WriteObjectValue<object>(item.Value);
            }
            writer.WriteEndObject();
        }

        internal static OciAnnotations DeserializeOciAnnotations(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            DateTimeOffset? orgOpencontainersImageCreated = default;
            string orgOpencontainersImageAuthors = default;
            Uri orgOpencontainersImageUrl = default;
            Uri orgOpencontainersImageDocumentation = default;
            Uri orgOpencontainersImageSource = default;
            string orgOpencontainersImageVersion = default;
            string orgOpencontainersImageRevision = default;
            string orgOpencontainersImageVendor = default;
            string orgOpencontainersImageLicenses = default;
            string orgOpencontainersImageRefName = default;
            string orgOpencontainersImageTitle = default;
            string orgOpencontainersImageDescription = default;
            IDictionary<string, object> additionalProperties = default;
            Dictionary<string, object> additionalPropertiesDictionary = new Dictionary<string, object>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("org.opencontainers.image.created"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    orgOpencontainersImageCreated = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("org.opencontainers.image.authors"u8))
                {
                    orgOpencontainersImageAuthors = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("org.opencontainers.image.url"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    orgOpencontainersImageUrl = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("org.opencontainers.image.documentation"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    orgOpencontainersImageDocumentation = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("org.opencontainers.image.source"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    orgOpencontainersImageSource = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("org.opencontainers.image.version"u8))
                {
                    orgOpencontainersImageVersion = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("org.opencontainers.image.revision"u8))
                {
                    orgOpencontainersImageRevision = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("org.opencontainers.image.vendor"u8))
                {
                    orgOpencontainersImageVendor = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("org.opencontainers.image.licenses"u8))
                {
                    orgOpencontainersImageLicenses = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("org.opencontainers.image.ref.name"u8))
                {
                    orgOpencontainersImageRefName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("org.opencontainers.image.title"u8))
                {
                    orgOpencontainersImageTitle = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("org.opencontainers.image.description"u8))
                {
                    orgOpencontainersImageDescription = property.Value.GetString();
                    continue;
                }
                additionalPropertiesDictionary.Add(property.Name, property.Value.GetObject());
            }
            additionalProperties = additionalPropertiesDictionary;
            return new OciAnnotations(
                orgOpencontainersImageCreated,
                orgOpencontainersImageAuthors,
                orgOpencontainersImageUrl,
                orgOpencontainersImageDocumentation,
                orgOpencontainersImageSource,
                orgOpencontainersImageVersion,
                orgOpencontainersImageRevision,
                orgOpencontainersImageVendor,
                orgOpencontainersImageLicenses,
                orgOpencontainersImageRefName,
                orgOpencontainersImageTitle,
                orgOpencontainersImageDescription,
                additionalProperties);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static OciAnnotations FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeOciAnnotations(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
