// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Containers.ContainerRegistry
{
    /// <summary> Returns the requested Docker multi-arch-manifest file. </summary>
    internal partial class ManifestList : Manifest
    {
        /// <summary> Initializes a new instance of <see cref="ManifestList"/>. </summary>
        internal ManifestList()
        {
            Manifests = new ChangeTrackingList<ManifestListAttributes>();
        }

        /// <summary> Initializes a new instance of <see cref="ManifestList"/>. </summary>
        /// <param name="schemaVersion"> Schema version. </param>
        /// <param name="mediaType"> Media type for this Manifest. </param>
        /// <param name="manifests"> List of V2 image layer information. </param>
        internal ManifestList(int? schemaVersion, string mediaType, IReadOnlyList<ManifestListAttributes> manifests) : base(schemaVersion)
        {
            MediaType = mediaType;
            Manifests = manifests;
        }

        /// <summary> Media type for this Manifest. </summary>
        public string MediaType { get; }
        /// <summary> List of V2 image layer information. </summary>
        public IReadOnlyList<ManifestListAttributes> Manifests { get; }
    }
}
