// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Containers.ContainerRegistry
{
    internal partial class JWKHeader
    {
        internal static JWKHeader DeserializeJWKHeader(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string crv = default;
            string kid = default;
            string kty = default;
            string x = default;
            string y = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("crv"u8))
                {
                    crv = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("kid"u8))
                {
                    kid = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("kty"u8))
                {
                    kty = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("x"u8))
                {
                    x = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("y"u8))
                {
                    y = property.Value.GetString();
                    continue;
                }
            }
            return new JWKHeader(crv, kid, kty, x, y);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static JWKHeader FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeJWKHeader(document.RootElement);
        }
    }
}
