// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Containers.ContainerRegistry
{
    /// <summary> A JSON web signature. </summary>
    internal partial class JWK
    {
        /// <summary> Initializes a new instance of <see cref="JWK"/>. </summary>
        internal JWK()
        {
        }

        /// <summary> Initializes a new instance of <see cref="JWK"/>. </summary>
        /// <param name="jwk"> JSON web key parameter. </param>
        /// <param name="alg"> The algorithm used to sign or encrypt the JWT. </param>
        internal JWK(JWKHeader jwk, string alg)
        {
            Jwk = jwk;
            Alg = alg;
        }

        /// <summary> JSON web key parameter. </summary>
        public JWKHeader Jwk { get; }
        /// <summary> The algorithm used to sign or encrypt the JWT. </summary>
        public string Alg { get; }
    }
}
