// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Containers.ContainerRegistry
{
    internal partial class JWK
    {
        internal static JWK DeserializeJWK(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            JWKHeader jwk = default;
            string alg = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("jwk"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    jwk = JWKHeader.DeserializeJWKHeader(property.Value);
                    continue;
                }
                if (property.NameEquals("alg"u8))
                {
                    alg = property.Value.GetString();
                    continue;
                }
            }
            return new JWK(jwk, alg);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static JWK FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeJWK(document.RootElement);
        }
    }
}
