// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Containers.ContainerRegistry
{
    internal partial class ImageSignature
    {
        internal static ImageSignature DeserializeImageSignature(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            JWK header = default;
            string signature = default;
            string @protected = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("header"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    header = JWK.DeserializeJWK(property.Value);
                    continue;
                }
                if (property.NameEquals("signature"u8))
                {
                    signature = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("protected"u8))
                {
                    @protected = property.Value.GetString();
                    continue;
                }
            }
            return new ImageSignature(header, signature, @protected);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static ImageSignature FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeImageSignature(document.RootElement);
        }
    }
}
