// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Containers.ContainerRegistry
{
    internal partial class History
    {
        internal static History DeserializeHistory(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string v1Compatibility = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("v1Compatibility"u8))
                {
                    v1Compatibility = property.Value.GetString();
                    continue;
                }
            }
            return new History(v1Compatibility);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static History FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeHistory(document.RootElement);
        }
    }
}
